/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.cli.wrapper.launcher;

import io.mongock.cli.wrapper.launcher.LauncherDefault;
import io.mongock.cli.wrapper.launcher.LauncherSpringboot;
import io.mongock.cli.wrapper.launcher.LauncherStandalone;
import io.mongock.cli.wrapper.util.JarUtil;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.springframework.boot.loader.archive.JarFileArchive;

public interface LauncherCliJar {
    public LauncherCliJar loadClasses();

    public void launch(String[] var1);

    public static LauncherBuilder builder() {
        return new LauncherBuilder();
    }

    public static class LauncherBuilder {
        private String cliSpringJar;
        private String cliCoreJar;
        private String appJarFile;
        private String mongockCoreJarFile;

        public LauncherBuilder setAppJarFile(String appJarFile) {
            this.appJarFile = appJarFile;
            return this;
        }

        public LauncherBuilder setCliSpringJar(String cliSpringJar) {
            this.cliSpringJar = cliSpringJar;
            return this;
        }

        public LauncherBuilder setCliCoreJar(String cliCoreJar) {
            this.cliCoreJar = cliCoreJar;
            return this;
        }

        public LauncherBuilder setMongockCoreJarFile(String mongockCoreJarFile) {
            this.mongockCoreJarFile = mongockCoreJarFile;
            return this;
        }

        public LauncherCliJar build() throws IOException {
            if (this.getAppJar().isPresent()) {
                JarFileArchive archive = new JarFileArchive(new File(this.appJarFile));
                if (JarUtil.isSpringApplication(archive)) {
                    return this.buildLauncherSpring(archive);
                }
                return this.buildLauncherStandalone(archive);
            }
            return this.buildLauncherWithoutApp();
        }

        private LauncherDefault buildLauncherWithoutApp() {
            this.validateNotNullParameter(this.mongockCoreJarFile, "parameter --mongock-core-jar");
            this.validateNotNullParameter(this.cliCoreJar, "parameter --cli-core-jar");
            return new LauncherDefault(this.mongockCoreJarFile, this.cliCoreJar);
        }

        private LauncherStandalone buildLauncherStandalone(JarFileArchive archive) {
            this.validateNotNullParameter(this.appJarFile, "parameter --app-jar");
            this.validateNotNullParameter(this.cliCoreJar, "parameter --cli-core-jar");
            return new LauncherStandalone(archive, this.appJarFile, this.cliCoreJar);
        }

        private LauncherSpringboot buildLauncherSpring(JarFileArchive archive) {
            this.validateNotNullParameter(this.appJarFile, "parameter --app-jar");
            this.validateNotNullParameter(this.cliSpringJar, "parameter --cli-spring-jar");
            return new LauncherSpringboot(archive, this.appJarFile, this.cliSpringJar);
        }

        private Optional<String> getAppJar() {
            return Optional.ofNullable(this.appJarFile);
        }

        private void validateNotNullParameter(Object parameter, String name) {
            if (parameter == null) {
                throw new RuntimeException(name + " must be provided");
            }
        }
    }
}

