/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.cli.wrapper.launcher.springboot;

import io.mongock.api.annotations.MongockCliConfiguration;
import io.mongock.cli.util.logger.CliLogger;
import io.mongock.cli.util.logger.CliLoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.boot.loader.MainMethodRunner;

public class CliMainMethodRunner
extends MainMethodRunner {
    private static final CliLogger logger = CliLoggerFactory.getLogger(CliMainMethodRunner.class);
    private final String cliMainClass;
    private final String originalMainClass;
    private final String[] mainArgs;

    public CliMainMethodRunner(String cliMainClass, String originalMainClass, String[] args) {
        super(cliMainClass, args);
        this.cliMainClass = cliMainClass;
        this.originalMainClass = originalMainClass;
        this.mainArgs = args != null ? (String[])args.clone() : null;
    }

    @Override
    public void run() throws Exception {
        Class<?> mainClass = Class.forName(this.cliMainClass, false, Thread.currentThread().getContextClassLoader());
        Class<?> originalMainClass = Class.forName(this.originalMainClass, false, Thread.currentThread().getContextClassLoader());
        this.setSources(mainClass, originalMainClass);
        this.runMainMethod(mainClass, this.mainArgs);
    }

    private void runMainMethod(Class<?> mainClass, String[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method mainMethod = mainClass.getDeclaredMethod("main", String[].class);
        mainMethod.setAccessible(true);
        mainMethod.invoke(null, new Object[]{args});
    }

    private void setSources(Class<?> cliMainClass, Class<?> originalMainClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        Class<?>[] classArray;
        if (originalMainClass.isAnnotationPresent(MongockCliConfiguration.class)) {
            classArray = this.getSources(originalMainClass);
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = originalMainClass;
        }
        Class<?>[] sources = classArray;
        Method method = cliMainClass.getDeclaredMethod("setSources", Class[].class);
        method.setAccessible(true);
        method.invoke(null, new Object[]{sources});
    }

    private Class<?>[] getSources(Class<?> originalMainClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        logger.debug("Sources added with " + MongockCliConfiguration.class.getSimpleName(), new Object[0]);
        MongockCliConfiguration annotation = originalMainClass.getAnnotation(MongockCliConfiguration.class);
        Method sourcesMethod = annotation.getClass().getDeclaredMethod("sources", new Class[0]);
        return (Class[])sourcesMethod.invoke((Object)annotation, new Object[0]);
    }
}

