/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.cli.core.commands.migrate;

import io.mongock.cli.core.VersionProvider;
import io.mongock.cli.core.commands.CommandBase;
import io.mongock.cli.core.commands.ProfessionalOperationProxy;
import io.mongock.runner.core.builder.RunnerBuilder;
import io.mongock.runner.core.executor.MongockRunner;
import io.mongock.runner.core.executor.operation.migrate.MigrateAllOperation;
import picocli.CommandLine;

@CommandLine.Command(name="migrate", description={""}, mixinStandardHelpOptions=true, versionProvider=VersionProvider.class)
public class MigrateCommand
extends CommandBase<Integer> {
    private static final String SUBCOMMAND_ALL = "all";
    private static final String SUBCOMMAND_UP_TO_CHANGE = "up-to-change";

    public MigrateCommand(RunnerBuilder builder) {
        super(builder);
    }

    @Override
    public Integer execution() throws Exception {
        this.printUsage();
        return 2;
    }

    @CommandLine.Command(name="all", description={"Executes all the pending changes (./mongock migrate all -h for more details)"}, mixinStandardHelpOptions=true, versionProvider=VersionProvider.class)
    public Integer all() {
        MongockRunner mongockRunner = this.builder.buildRunner(new MigrateAllOperation());
        mongockRunner.forceEnable();
        mongockRunner.execute();
        return 0;
    }

    @CommandLine.Command(name="up-to-change", description={"(pro) - Executes all the pending changes up to specified changeUnitId (./mongock migrate up-to-change -h for more details)"}, mixinStandardHelpOptions=true, versionProvider=VersionProvider.class)
    public Integer upToChange(@CommandLine.Parameters(index="0", description={"ChangeUnit id up to which Mongock will execute migration(inclusive)."}, paramLabel="<CHANGE_UNIT_ID>") String changeUnitId) {
        if (!this.checkProfessionalBuilder()) {
            return 2;
        }
        MongockRunner mongockRunner = this.builder.buildRunner(ProfessionalOperationProxy.migrateUpToChangeOperation(changeUnitId));
        mongockRunner.forceEnable();
        mongockRunner.execute();
        return 0;
    }
}

