/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.cli.util.output;

import com.diogonunes.jcolor.Ansi;
import com.diogonunes.jcolor.Attribute;
import io.mongock.cli.util.output.CustomColumnFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class OutputFormatter {
    private static final String LINE_SEPARATOR = System.lineSeparator();

    public static void printTable(String[][] table, int maxWidth, Consumer<String> printer, CustomColumnFormatter customColumnFormatter) {
        Attribute[][] finalAttributes;
        String[][] finalTable;
        if (table == null || table.length == 0) {
            return;
        }
        boolean leftJustifiedRows = true;
        int rows = table.length;
        int columns = table[0].length;
        Attribute[][] attributes = new Attribute[rows][columns];
        if (customColumnFormatter != null) {
            Stream.iterate(0, i -> {
                i = i + 1;
                return i;
            }).limit(rows).forEach(i -> Stream.iterate(0, j -> {
                j = j + 1;
                return j;
            }).limit(columns).forEach(j -> {
                attributes[i.intValue()][j.intValue()] = customColumnFormatter.get(table[0][j], i == 0, table[i][j]);
            }));
        }
        Arrays.stream(table).forEach(a -> Stream.iterate(0, i -> {
            i = i + 1;
            return i;
        }).limit(((String[])a).length).forEach(i -> {
            if (a[i] == null) {
                a[i.intValue()] = "";
            }
        }));
        if (maxWidth > 0) {
            int i2;
            ArrayList tableList = new ArrayList(Arrays.asList(table));
            ArrayList<String[]> finalTableList = new ArrayList<String[]>();
            ArrayList<Attribute[]> finalAttributeList = new ArrayList<Attribute[]>();
            for (i2 = 0; i2 < rows; ++i2) {
                String[] row = (String[])tableList.get(i2);
                boolean needExtraRow = false;
                int splitRow = 0;
                do {
                    needExtraRow = false;
                    String[] newRow = new String[row.length];
                    for (int j = 0; j < row.length; ++j) {
                        if (row[j].length() < maxWidth) {
                            newRow[j] = splitRow == 0 ? row[j] : "";
                            continue;
                        }
                        if (row[j].length() > splitRow * maxWidth) {
                            int end = row[j].length() > splitRow * maxWidth + maxWidth ? splitRow * maxWidth + maxWidth : row[j].length();
                            newRow[j] = row[j].substring(splitRow * maxWidth, end);
                            needExtraRow = true;
                            continue;
                        }
                        newRow[j] = "";
                    }
                    finalTableList.add(newRow);
                    finalAttributeList.add(attributes[i2]);
                    if (!needExtraRow) continue;
                    ++splitRow;
                } while (needExtraRow);
            }
            finalTable = new String[finalTableList.size()][((String[])finalTableList.get(0)).length];
            for (i2 = 0; i2 < finalTable.length; ++i2) {
                finalTable[i2] = (String[])finalTableList.get(i2);
            }
            rows = finalTable.length;
            finalAttributes = new Attribute[finalAttributeList.size()][columns];
            for (i2 = 0; i2 < finalAttributes.length; ++i2) {
                finalAttributes[i2] = (Attribute[])finalAttributeList.get(i2);
            }
        } else {
            finalTable = table;
            finalAttributes = attributes;
        }
        HashMap columnLengths = new HashMap();
        Arrays.stream(finalTable).forEach(a -> Stream.iterate(0, i -> {
            i = i + 1;
            return i;
        }).limit(((String[])a).length).forEach(i -> {
            if (columnLengths.get(i) == null) {
                columnLengths.put(i, 0);
            }
            if ((Integer)columnLengths.get(i) < a[i].length()) {
                columnLengths.put(i, a[i].length());
            }
        }));
        String flag = leftJustifiedRows ? "-" : "";
        Arrays.stream(finalTable).forEach(a -> Stream.iterate(0, i -> {
            i = i + 1;
            return i;
        }).limit(((String[])a).length).forEach(i -> {
            a[i.intValue()] = String.format("%" + flag + columnLengths.get(i) + "s", a[i]);
        }));
        if (finalAttributes != null) {
            Stream.iterate(0, i -> {
                i = i + 1;
                return i;
            }).limit(rows).forEach(i -> Stream.iterate(0, j -> {
                j = j + 1;
                return j;
            }).limit(columns).forEach(j -> {
                if (finalAttributes[i][j] != null) {
                    finalTable[i.intValue()][j.intValue()] = Ansi.colorize((String)finalTable[i][j], (Attribute[])new Attribute[]{finalAttributes[i][j]});
                }
            }));
        }
        StringBuilder formatString = new StringBuilder("");
        columnLengths.entrySet().stream().forEach(e -> formatString.append("| %s "));
        formatString.append("|");
        formatString.append(LINE_SEPARATOR);
        String line = columnLengths.entrySet().stream().reduce("", (ln, b) -> {
            String templn = "+-";
            templn = templn + Stream.iterate(0, i -> {
                i = i + 1;
                return i;
            }).limit(((Integer)b.getValue()).intValue()).reduce("", (ln1, b1) -> ln1 + "-", (a1, b1) -> a1 + b1);
            templn = templn + "-";
            return ln + templn;
        }, (a, b) -> a + b);
        line = line + "+" + LINE_SEPARATOR;
        StringBuilder result = new StringBuilder();
        result.append(line);
        Arrays.stream(finalTable).limit(1L).forEach(a -> result.append("| ").append(String.join((CharSequence)" | ", a)).append(" |").append(LINE_SEPARATOR));
        result.append(line);
        Stream.iterate(1, i -> {
            i = i + 1;
            return i;
        }).limit(finalTable.length - 1).forEach(a -> result.append("| ").append(String.join((CharSequence)" | ", finalTable[a])).append(" |").append(LINE_SEPARATOR));
        result.append(line);
        printer.accept(result.toString());
    }
}

