/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.cli.core;

import io.mongock.cli.core.CommandDefinition;
import io.mongock.cli.core.CommandLineDecorator;
import io.mongock.cli.core.commands.MainCommand;
import io.mongock.cli.core.commands.migrate.MigrateCommand;
import io.mongock.cli.core.commands.state.StateCommand;
import io.mongock.cli.core.commands.undo.UndoCommand;
import io.mongock.runner.core.builder.RunnerBuilder;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import picocli.CommandLine;

public class CliCoreRunner {
    public static Builder builder() {
        return new Builder();
    }

    private CliCoreRunner() {
    }

    public static class Builder {
        private final Set<CommandDefinition> commands = new HashSet<CommandDefinition>();
        private CommandLine.IFactory factory;
        private RunnerBuilder builder;

        private Builder() {
        }

        public Builder addCommand(String name, Callable command) {
            this.commands.add(new CommandDefinition(name, command));
            return this;
        }

        public Builder factory(CommandLine.IFactory factory) {
            this.factory = factory;
            return this;
        }

        public Builder runnerBuilder(RunnerBuilder builder) {
            this.builder = builder;
            return this;
        }

        public CommandLine build() {
            this.addCommand("undo", new UndoCommand(this.builder));
            this.addCommand("migrate", new MigrateCommand(this.builder));
            this.addCommand("state", new StateCommand(this.builder));
            return this.getFactory().map(f -> new CommandLineDecorator(new MainCommand(), (CommandLine.IFactory)f)).orElseGet(() -> new CommandLineDecorator(new MainCommand())).addSubCommands(this.commands);
        }

        private Optional<CommandLine.IFactory> getFactory() {
            return Optional.ofNullable(this.factory);
        }
    }
}

