/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.cli.springboot;

import io.mongock.cli.core.CliCoreRunner;
import io.mongock.cli.springboot.MongockBanner;
import io.mongock.cli.util.logger.CliLogger;
import io.mongock.cli.util.logger.CliLoggerFactory;
import io.mongock.runner.core.builder.RunnerBuilder;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import picocli.CommandLine;

@SpringBootApplication
class CliSpringbootRunner
implements CommandLineRunner,
ExitCodeGenerator {
    private static final CliLogger logger = CliLoggerFactory.getLogger(CliSpringbootRunner.class);
    private static Class<?>[] sources;
    private int exitCode;
    @Autowired
    private RunnerBuilder builder;
    @Autowired(required=false)
    private CommandLine.IFactory factory;

    CliSpringbootRunner() {
    }

    public static void setSources(Class<?> ... sources) {
        CliSpringbootRunner.sources = new Class[sources.length + 1];
        CliSpringbootRunner.sources[0] = CliSpringbootRunner.class;
        for (int i = 0; i < sources.length; ++i) {
            Class<?> source = sources[i];
            logger.debug("Setting config source: {}", source);
            CliSpringbootRunner.sources[i + 1] = source;
        }
    }

    public static Class<?>[] getSources() {
        if (sources != null) {
            return sources;
        }
        logger.warn("Sources not added. This will probably cause the process to break", new Object[0]);
        return new Class[]{CliSpringbootRunner.class};
    }

    public static void main(String ... args) {
        Properties properties = CliSpringbootRunner.getProperties();
        SpringApplicationBuilder springApplicationBuilder = new SpringApplicationBuilder(new Class[0]).web(WebApplicationType.NONE).banner(new MongockBanner()).logStartupInfo(false).sources(CliSpringbootRunner.getSources()).properties(properties).profiles("mongock-cli-profile");
        System.exit(SpringApplication.exit(springApplicationBuilder.run(args), new ExitCodeGenerator[0]));
    }

    private static Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("spring.main.banner-mode", "off");
        properties.setProperty("logging.level.root", "ERROR");
        properties.setProperty("logging.level.io.mongock", "INFO");
        return properties;
    }

    @Override
    public void run(String ... args) {
        if (args.length == 0) {
            logger.error("command format: 'mongock [operation] [parameters]'", new Object[0]);
            this.exitCode = 2;
        } else {
            this.exitCode = CliCoreRunner.builder().factory(this.factory).runnerBuilder(this.builder).build().execute(args);
        }
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }
}

