/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.api.lock.guard.proxy;

import io.changock.migration.api.annotations.NonLockGuarded;
import io.mongock.driver.api.lock.LockManager;
import io.mongock.driver.api.lock.guard.proxy.LockGuardMethodHandler;
import io.mongock.utils.Utils;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.util.proxy.ProxyFactory;
import org.objenesis.ObjenesisStd;

public class LockGuardProxyFactory {
    private static final Set<String> DEFAULT_NON_GUARDED_METHODS = new HashSet<String>(Collections.singletonList("finalize"));
    private static final List<String> javaPackagePrefixes;
    private final LockManager lockManager;
    private final Collection<String> notProxiedPackagePrefixes;
    private final Set<String> nonGuardedMethods;

    public LockGuardProxyFactory(LockManager lockManager) {
        this(lockManager, Collections.emptyList(), DEFAULT_NON_GUARDED_METHODS);
    }

    public LockGuardProxyFactory(LockManager lockManager, Collection<String> notProxiedPackagePrefixes) {
        this(lockManager, notProxiedPackagePrefixes, DEFAULT_NON_GUARDED_METHODS);
    }

    public LockGuardProxyFactory(LockManager lockManager, Collection<String> notProxiedPackagePrefixes, Set<String> nonGuardedMethods) {
        this.lockManager = lockManager;
        this.notProxiedPackagePrefixes = new ArrayList<String>(notProxiedPackagePrefixes);
        this.notProxiedPackagePrefixes.addAll(javaPackagePrefixes);
        this.nonGuardedMethods = nonGuardedMethods;
    }

    public <T> T getProxy(T targetObject, Class<? super T> interfaceType) {
        return (T)this.getRawProxy(targetObject, interfaceType);
    }

    public Object getRawProxy(Object targetObject, Class<?> interfaceType) {
        return this.shouldBeLockGuardProxied(targetObject, interfaceType) ? this.createProxy(targetObject, interfaceType) : targetObject;
    }

    private boolean shouldBeLockGuardProxied(Object targetObject, Class<?> interfaceType) {
        return targetObject != null && !Modifier.isFinal(interfaceType.getModifiers()) && this.isPackageProxiable(interfaceType.getPackage().getName()) && !interfaceType.isAnnotationPresent(NonLockGuarded.class) && !targetObject.getClass().isAnnotationPresent(NonLockGuarded.class) && !Utils.isBasicTypeJDK(targetObject.getClass()) && !Utils.isBasicTypeJDK(interfaceType);
    }

    private boolean isPackageProxiable(String packageName) {
        return this.notProxiedPackagePrefixes.stream().noneMatch(packageName::startsWith);
    }

    private Object createProxy(Object impl, Class<?> type) {
        ProxyFactory proxyFactory = new ProxyFactory();
        if (type.isInterface()) {
            proxyFactory.setInterfaces(new Class[]{type});
        } else {
            proxyFactory.setSuperclass(type);
        }
        Object proxyInstance = new ObjenesisStd().getInstantiatorOf(proxyFactory.createClass()).newInstance();
        ((javassist.util.proxy.Proxy)proxyInstance).setHandler(new LockGuardMethodHandler<Object>(impl, this.lockManager, this, this.nonGuardedMethods));
        return proxyInstance;
    }

    public static boolean isProxy(Object obj) {
        return LockGuardProxyFactory.isProxyClass(obj.getClass());
    }

    public static boolean isProxyClass(Class<?> c) {
        return Proxy.isProxyClass(c) || ProxyFactory.isProxyClass(c);
    }

    public static void checkProxy(Object obj) {
        if (!LockGuardProxyFactory.isProxyClass(obj.getClass())) {
            throw new RuntimeException("Is not proxy");
        }
    }

    static {
        ProxyFactory.nameGenerator = new ProxyFactory.UniqueName(){
            private final String sep = "_$$_mongock_" + Integer.toHexString(this.hashCode() & 0xFFF) + "_";
            private int counter = 0;

            @Override
            public String get(String classname) {
                return classname + this.sep + Integer.toHexString(this.counter++);
            }
        };
        javaPackagePrefixes = Collections.emptyList();
    }
}

