/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.annotation;

import io.mongock.api.annotations.BeforeExecution;
import io.mongock.api.annotations.Execution;
import io.mongock.api.annotations.RollbackBeforeExecution;
import io.mongock.api.annotations.RollbackExecution;
import io.mongock.api.exception.MongockException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.stream.Stream;

public class AnnotationProcessor {
    public Method getExecuteMethod(Class<?> changeUnitClass) {
        Class<Execution> annotation = Execution.class;
        return this.findMethodByAnnotation(changeUnitClass, annotation).orElseThrow(() -> new MongockException("ChangeUnit[%s] without %s method", changeUnitClass.getName(), annotation.getSimpleName()));
    }

    public Method getRollbackMethod(Class<?> changeUnitClass) {
        Class<RollbackExecution> annotation = RollbackExecution.class;
        return this.findMethodByAnnotation(changeUnitClass, annotation).orElseThrow(() -> new MongockException("ChangeUnit[%s] without %s method", changeUnitClass.getName(), annotation.getSimpleName()));
    }

    public Optional<Method> getBeforeMethod(Class<?> changeUnitClass) {
        return this.findMethodByAnnotation(changeUnitClass, BeforeExecution.class);
    }

    public Optional<Method> getRollbackBeforeMethod(Class<?> changeUnitClass) {
        return this.findMethodByAnnotation(changeUnitClass, RollbackBeforeExecution.class);
    }

    private Optional<Method> findMethodByAnnotation(Class<?> changeUnitClass, Class<? extends Annotation> annotation) {
        return this.getMethodStreamByAnnotation(changeUnitClass, annotation).findAny();
    }

    private Stream<Method> getMethodStreamByAnnotation(Class<?> changeUnitClass, Class<? extends Annotation> annotation) {
        return Stream.of(changeUnitClass.getMethods()).filter(method -> method.isAnnotationPresent(annotation));
    }

    public void validateChangeUnit(Class<?> changeUnitClass) {
        long rollbackBeforeCount;
        long beforeCount;
        long rollbackCount;
        boolean error = false;
        StringBuilder errorMessage = new StringBuilder();
        long executionCount = this.getMethodStreamByAnnotation(changeUnitClass, Execution.class).count();
        if (executionCount != 1L) {
            error = true;
            errorMessage.append(String.format("ChangeUnit[%s] must have only one %s method", changeUnitClass.getName(), Execution.class.getSimpleName())).append("\n");
        }
        if ((rollbackCount = this.getMethodStreamByAnnotation(changeUnitClass, RollbackExecution.class).count()) != 1L) {
            error = true;
            errorMessage.append(String.format("ChangeUnit[%s] must have only one %s method", changeUnitClass.getName(), RollbackExecution.class.getSimpleName())).append("\n");
        }
        if ((beforeCount = this.getMethodStreamByAnnotation(changeUnitClass, BeforeExecution.class).count()) > 1L) {
            error = true;
            errorMessage.append(String.format("ChangeUnit[%s] can have at most one %s method", changeUnitClass.getName(), BeforeExecution.class.getSimpleName())).append("\n");
        } else if (beforeCount == 1L && (rollbackBeforeCount = this.getMethodStreamByAnnotation(changeUnitClass, RollbackBeforeExecution.class).count()) != 1L) {
            error = true;
            errorMessage.append(String.format("When ChangeUnit[%s] provides %s method, it must provide one(and only one) %s method", changeUnitClass.getName(), BeforeExecution.class.getSimpleName(), RollbackBeforeExecution.class.getSimpleName())).append("\n");
        }
        if (error) {
            throw new MongockException(errorMessage.toString());
        }
    }
}

