/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.executor.changelog;

import io.mongock.api.annotations.ChangeUnit;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.common.SystemChange;
import io.mongock.runner.core.annotation.AnnotationProcessor;
import io.mongock.runner.core.annotation.LegacyAnnotationProcessor;
import io.mongock.runner.core.annotation.LegacyLegacyAnnotationProcessor;
import io.mongock.runner.core.executor.changelog.ChangeLogServiceBase;
import io.mongock.runner.core.internal.ChangeLogItem;
import io.mongock.utils.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class ChangeLogService
extends ChangeLogServiceBase {
    private static final LegacyLegacyAnnotationProcessor LEGACY_ANNOTATION_PROCESSOR = new LegacyLegacyAnnotationProcessor();
    private static final AnnotationProcessor DEFAULT_ANNOTATION_PROCESSOR = new AnnotationProcessor();

    public ChangeLogService(List<String> changeLogsBasePackageList, List<Class<?>> changeLogsBaseClassList, String startSystemVersionInclusive, String endSystemVersionInclusive) {
        this(changeLogsBasePackageList, changeLogsBaseClassList, startSystemVersionInclusive, endSystemVersionInclusive, null);
    }

    public ChangeLogService(List<String> changeLogsBasePackageList, List<Class<?>> changeLogsBaseClassList, String startSystemVersionInclusive, String endSystemVersionInclusive, Function<AnnotatedElement, Boolean> profileFilter) {
        this();
        this.setChangeLogsBasePackageList(new ArrayList<String>(changeLogsBasePackageList));
        this.setChangeLogsBaseClassList(changeLogsBaseClassList);
        this.setStartSystemVersion(startSystemVersionInclusive);
        this.setEndSystemVersion(endSystemVersionInclusive);
        this.setProfileFilter(profileFilter);
    }

    public ChangeLogService() {
        super(DEFAULT_ANNOTATION_PROCESSOR, LEGACY_ANNOTATION_PROCESSOR);
    }

    @Override
    protected ChangeLogItem buildChangeLogInstance(Class<?> changeUnitClass) throws MongockException {
        ChangeUnit changeUnit = changeUnitClass.getAnnotation(ChangeUnit.class);
        AnnotationProcessor annotationProcessor = this.getAnnotationProcessor();
        annotationProcessor.validateChangeUnit(changeUnitClass);
        return ChangeLogItem.getFromAnnotation(changeUnitClass, changeUnit.id(), StringUtils.hasText(changeUnit.author()) ? changeUnit.author() : this.getDefaultMigrationAuthor(), changeUnit.order(), changeUnit.failFast(), changeUnit.transactional(), changeUnit.runAlways(), changeUnit.systemVersion(), annotationProcessor.getExecuteMethod(changeUnitClass), annotationProcessor.getRollbackMethod(changeUnitClass), annotationProcessor.getBeforeMethod(changeUnitClass).orElse(null), annotationProcessor.getRollbackBeforeMethod(changeUnitClass).orElse(null), changeUnitClass.isAnnotationPresent(SystemChange.class));
    }

    @Override
    protected ChangeLogItem buildChangeLogInstanceFromLegacy(Class<?> changeLogClass) {
        LegacyAnnotationProcessor annProcessor = this.getLegacyAnnotationProcessor();
        return ChangeLogItem.getFromLegacy(changeLogClass, annProcessor.getChangeLogOrder(changeLogClass), annProcessor.isFailFast(changeLogClass), this.fetchListOfChangeSetsFromClass(changeLogClass), changeLogClass.isAnnotationPresent(SystemChange.class));
    }
}

