/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.web.reactive.context.AnnotationConfigReactiveWebServerApplicationContext;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

@FunctionalInterface
public interface ApplicationContextFactory {
    public static final ApplicationContextFactory DEFAULT = webApplicationType -> {
        try {
            switch (webApplicationType) {
                case SERVLET: {
                    return new AnnotationConfigServletWebServerApplicationContext();
                }
                case REACTIVE: {
                    return new AnnotationConfigReactiveWebServerApplicationContext();
                }
            }
            return new AnnotationConfigApplicationContext();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable create a default ApplicationContext instance, you may need a custom ApplicationContextFactory", ex);
        }
    };

    public ConfigurableApplicationContext create(WebApplicationType var1);

    public static ApplicationContextFactory ofContextClass(Class<? extends ConfigurableApplicationContext> contextClass) {
        return ApplicationContextFactory.of(() -> (ConfigurableApplicationContext)BeanUtils.instantiateClass(contextClass));
    }

    public static ApplicationContextFactory of(Supplier<ConfigurableApplicationContext> supplier) {
        return webApplicationType -> (ConfigurableApplicationContext)supplier.get();
    }
}

