/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.hateoas;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.server.mvc.TypeConstrainedMappingJackson2HttpMessageConverter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Configuration(proxyBeanMethods=false)
public class HypermediaHttpMessageConverterConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="spring.hateoas", name={"use-hal-as-default-json-media-type"}, matchIfMissing=true)
    public static HalMessageConverterSupportedMediaTypesCustomizer halMessageConverterSupportedMediaTypeCustomizer() {
        return new HalMessageConverterSupportedMediaTypesCustomizer();
    }

    private static class HalMessageConverterSupportedMediaTypesCustomizer
    implements BeanFactoryAware,
    InitializingBean {
        private volatile BeanFactory beanFactory;

        private HalMessageConverterSupportedMediaTypesCustomizer() {
        }

        @Override
        public void afterPropertiesSet() {
            if (this.beanFactory instanceof ListableBeanFactory) {
                this.configureHttpMessageConverters(((ListableBeanFactory)this.beanFactory).getBeansOfType(RequestMappingHandlerAdapter.class).values());
            }
        }

        private void configureHttpMessageConverters(Collection<RequestMappingHandlerAdapter> handlerAdapters) {
            for (RequestMappingHandlerAdapter handlerAdapter : handlerAdapters) {
                for (HttpMessageConverter messageConverter : handlerAdapter.getMessageConverters()) {
                    this.configureHttpMessageConverter(messageConverter);
                }
            }
        }

        private void configureHttpMessageConverter(HttpMessageConverter<?> converter) {
            if (converter instanceof TypeConstrainedMappingJackson2HttpMessageConverter) {
                ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>(converter.getSupportedMediaTypes());
                if (!supportedMediaTypes.contains(MediaType.APPLICATION_JSON)) {
                    supportedMediaTypes.add(MediaType.APPLICATION_JSON);
                }
                ((AbstractHttpMessageConverter)converter).setSupportedMediaTypes(supportedMediaTypes);
            }
        }

        @Override
        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }
    }
}

