/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigDataEnvironmentContributor;
import org.springframework.boot.context.config.ConfigDataException;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;

public class InvalidConfigDataPropertyException
extends ConfigDataException {
    private static final Map<ConfigurationPropertyName, ConfigurationPropertyName> WARNING;
    private final ConfigurationProperty property;
    private final ConfigurationPropertyName replacement;
    private final ConfigDataResource location;

    InvalidConfigDataPropertyException(ConfigurationProperty property, ConfigurationPropertyName replacement, ConfigDataResource location) {
        super(InvalidConfigDataPropertyException.getMessage(property, replacement, location), null);
        this.property = property;
        this.replacement = replacement;
        this.location = location;
    }

    public ConfigurationProperty getProperty() {
        return this.property;
    }

    public ConfigDataResource getLocation() {
        return this.location;
    }

    public ConfigurationPropertyName getReplacement() {
        return this.replacement;
    }

    static void throwOrWarn(Log logger, ConfigDataEnvironmentContributor contributor) {
        ConfigurationPropertySource propertySource = contributor.getConfigurationPropertySource();
        if (propertySource != null) {
            WARNING.forEach((invalid, replacement) -> {
                ConfigurationProperty property = propertySource.getConfigurationProperty((ConfigurationPropertyName)invalid);
                if (property != null) {
                    logger.warn(InvalidConfigDataPropertyException.getMessage(property, replacement, contributor.getResource()));
                }
            });
        }
    }

    private static String getMessage(ConfigurationProperty property, ConfigurationPropertyName replacement, ConfigDataResource location) {
        StringBuilder message = new StringBuilder("Property '");
        message.append(property.getName());
        if (location != null) {
            message.append("' imported from location '");
            message.append(location);
        }
        message.append("' is invalid");
        if (replacement != null) {
            message.append(" and should be replaced with '");
            message.append(replacement);
            message.append("'");
        }
        if (property.getOrigin() != null) {
            message.append(" [origin: ");
            message.append(property.getOrigin());
            message.append("]");
        }
        return message.toString();
    }

    static {
        LinkedHashMap<ConfigurationPropertyName, ConfigurationPropertyName> warning = new LinkedHashMap<ConfigurationPropertyName, ConfigurationPropertyName>();
        warning.put(ConfigurationPropertyName.of("spring.profiles"), ConfigurationPropertyName.of("spring.config.activate.on-profile"));
        WARNING = Collections.unmodifiableMap(warning);
    }
}

