/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.netty;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.boot.web.embedded.netty.CompressionCustomizer;
import org.springframework.boot.web.embedded.netty.NettyRouteProvider;
import org.springframework.boot.web.embedded.netty.NettyServerCustomizer;
import org.springframework.boot.web.embedded.netty.NettyWebServer;
import org.springframework.boot.web.embedded.netty.SslServerCustomizer;
import org.springframework.boot.web.reactive.server.AbstractReactiveWebServerFactory;
import org.springframework.boot.web.server.Shutdown;
import org.springframework.boot.web.server.WebServer;
import org.springframework.http.client.reactive.ReactorResourceFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import org.springframework.util.Assert;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.server.HttpServer;
import reactor.netty.resources.LoopResources;

public class NettyReactiveWebServerFactory
extends AbstractReactiveWebServerFactory {
    private Set<NettyServerCustomizer> serverCustomizers = new LinkedHashSet<NettyServerCustomizer>();
    private List<NettyRouteProvider> routeProviders = new ArrayList<NettyRouteProvider>();
    private Duration lifecycleTimeout;
    private boolean useForwardHeaders;
    private ReactorResourceFactory resourceFactory;
    private Shutdown shutdown;

    public NettyReactiveWebServerFactory() {
    }

    public NettyReactiveWebServerFactory(int port) {
        super(port);
    }

    @Override
    public WebServer getWebServer(HttpHandler httpHandler) {
        HttpServer httpServer = this.createHttpServer();
        ReactorHttpHandlerAdapter handlerAdapter = new ReactorHttpHandlerAdapter(httpHandler);
        NettyWebServer webServer = new NettyWebServer(httpServer, handlerAdapter, this.lifecycleTimeout, this.getShutdown());
        webServer.setRouteProviders(this.routeProviders);
        return webServer;
    }

    public Collection<NettyServerCustomizer> getServerCustomizers() {
        return this.serverCustomizers;
    }

    public void setServerCustomizers(Collection<? extends NettyServerCustomizer> serverCustomizers) {
        Assert.notNull(serverCustomizers, "ServerCustomizers must not be null");
        this.serverCustomizers = new LinkedHashSet<NettyServerCustomizer>(serverCustomizers);
    }

    public void addServerCustomizers(NettyServerCustomizer ... serverCustomizers) {
        Assert.notNull((Object)serverCustomizers, "ServerCustomizer must not be null");
        this.serverCustomizers.addAll(Arrays.asList(serverCustomizers));
    }

    public void addRouteProviders(NettyRouteProvider ... routeProviders) {
        Assert.notNull((Object)routeProviders, "NettyRouteProvider must not be null");
        this.routeProviders.addAll(Arrays.asList(routeProviders));
    }

    public void setLifecycleTimeout(Duration lifecycleTimeout) {
        this.lifecycleTimeout = lifecycleTimeout;
    }

    public void setUseForwardHeaders(boolean useForwardHeaders) {
        this.useForwardHeaders = useForwardHeaders;
    }

    public void setResourceFactory(ReactorResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    @Override
    public void setShutdown(Shutdown shutdown) {
        this.shutdown = shutdown;
    }

    @Override
    public Shutdown getShutdown() {
        return this.shutdown;
    }

    private HttpServer createHttpServer() {
        HttpServer server = HttpServer.create();
        if (this.resourceFactory != null) {
            LoopResources resources = this.resourceFactory.getLoopResources();
            Assert.notNull((Object)resources, "No LoopResources: is ReactorResourceFactory not initialized yet?");
            server = ((HttpServer)server.runOn(resources)).bindAddress(this::getListenAddress);
        } else {
            server = server.bindAddress(this::getListenAddress);
        }
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            SslServerCustomizer sslServerCustomizer = new SslServerCustomizer(this.getSsl(), this.getHttp2(), this.getSslStoreProvider());
            server = sslServerCustomizer.apply(server);
        }
        if (this.getCompression() != null && this.getCompression().getEnabled()) {
            CompressionCustomizer compressionCustomizer = new CompressionCustomizer(this.getCompression());
            server = compressionCustomizer.apply(server);
        }
        server = server.protocol(this.listProtocols()).forwarded(this.useForwardHeaders);
        return this.applyCustomizers(server);
    }

    private HttpProtocol[] listProtocols() {
        if (this.getHttp2() != null && this.getHttp2().isEnabled() && this.getSsl() != null && this.getSsl().isEnabled()) {
            return new HttpProtocol[]{HttpProtocol.H2, HttpProtocol.HTTP11};
        }
        return new HttpProtocol[]{HttpProtocol.HTTP11};
    }

    private InetSocketAddress getListenAddress() {
        if (this.getAddress() != null) {
            return new InetSocketAddress(this.getAddress().getHostAddress(), this.getPort());
        }
        return new InetSocketAddress(this.getPort());
    }

    private HttpServer applyCustomizers(HttpServer server) {
        for (NettyServerCustomizer customizer2 : this.serverCustomizers) {
            server = (HttpServer)customizer2.apply(server);
        }
        return server;
    }
}

