/*
 * Decompiled with CFR 0.152.
 */
package minitest.api;

import java.io.Serializable;
import minitest.api.AssertionException;
import minitest.api.CanceledException;
import minitest.api.IgnoredException;
import minitest.api.Result;
import minitest.api.SourceLocation;
import minitest.api.UnexpectedException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.compat.Platform$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class Result$ {
    public static Result$ MODULE$;

    static {
        new Result$();
    }

    public Result<Nothing$> from(Throwable error) {
        Product product;
        Throwable throwable = error;
        if (throwable instanceof AssertionException) {
            AssertionException assertionException = (AssertionException)throwable;
            product = new Result.Failure(assertionException.message(), (Option<Throwable>)new Some((Object)assertionException), (Option<SourceLocation>)new Some((Object)assertionException.location()));
        } else if (throwable instanceof UnexpectedException) {
            UnexpectedException unexpectedException = (UnexpectedException)throwable;
            product = new Result.Exception(unexpectedException.reason(), (Option<SourceLocation>)new Some((Object)unexpectedException.location()));
        } else if (throwable instanceof IgnoredException) {
            IgnoredException ignoredException = (IgnoredException)throwable;
            product = new Result.Ignored(ignoredException.reason(), ignoredException.location());
        } else if (throwable instanceof CanceledException) {
            CanceledException canceledException = (CanceledException)throwable;
            product = new Result.Canceled(canceledException.reason(), canceledException.location());
        } else {
            product = new Result.Exception(throwable, (Option<SourceLocation>)None$.MODULE$);
        }
        return product;
    }

    public String minitest$api$Result$$formatError(String name, String msg, Option<Throwable> source, Option<SourceLocation> location, Option<Object> traceLimit) {
        String stackTrace = (String)source.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)ex -> {
            String[] tr = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ex.getStackTrace())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            String[] trace = (String[])traceLimit.fold((Function0 & Serializable & scala.Serializable)() -> tr, (Function1 & Serializable & scala.Serializable)limit -> Result$.$anonfun$formatError$5(tr, BoxesRunTime.unboxToInt((Object)limit)));
            return this.minitest$api$Result$$formatDescription(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trace)).mkString("\n"), (Option<SourceLocation>)None$.MODULE$, "\u001b[31m", "    ");
        });
        String formattedMessage = this.minitest$api$Result$$formatDescription(msg != null && new StringOps(Predef$.MODULE$.augmentString(msg)).nonEmpty() ? msg : "Test failed", location, "\u001b[31m", "  ");
        return "\u001b[31m" + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"- ", " *** FAILED ***"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})) + Platform$.MODULE$.EOL() + formattedMessage + stackTrace;
    }

    public String minitest$api$Result$$formatDescription(String message, Option<SourceLocation> location, String color, String prefix) {
        String[] lines = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])message.split("\\r?\\n"))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String line = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String string = index == 0 ? color + prefix + line + location.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)l -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (", ":", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l.path(), BoxesRunTime.boxToInteger((int)l.line())}))) + Platform$.MODULE$.EOL() : color + prefix + line + Platform$.MODULE$.EOL();
            return string;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).mkString();
    }

    public static final /* synthetic */ String[] $anonfun$formatError$5(String[] tr$1, int limit) {
        return tr$1.length <= limit ? tr$1 : (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tr$1)).take(limit))).$colon$plus((Object)"...", ClassTag$.MODULE$.apply(String.class));
    }

    private Result$() {
        MODULE$ = this;
    }
}

