/* CXX header documentation injected w/doxyport */

/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.8
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

/**
* @brief ST Microelectronics Ultra-compact high-performance
* eCompass module
* @defgroup lsm303d libupm-lsm303d
* @ingroup i2c gpio stmicro compass accelerometer
*/
package upm_lsm303d;

/**
* @library lsm303d
* @sensor lsm303d
* @comname Ultra-compact high-performance eCompass module
* @type compass
* @man stmicro
* @con i2c gpio
* @web http://www.st.com/en/mems-and-sensors/lsm303d.html
*
* @brief API for the LSM303D 3-Axis Geomagnetic Sensor
*
* The LSM303D is an ultra-low-power high-performance
* system-in-package featuring a 3D digital linear acceleration
* sensor and a 3D digital magnetic sensor.  The LSM303D has
* linear acceleration full scales of 2g/4g/8g/16g and a
* magnetic field dynamic range of 50 Gauss.
*
* Not all functionality of this chip has been implemented in this
* driver, however all the pieces are present to add any desired
* functionality.  This driver supports only I2C operation.
*
* This device requires 3.3v operation.
*
* @snippet lsm303d.cxx Interesting
*/
public class LSM303D {
  private transient long swigCPtr;
  private transient boolean swigCMemOwn;

/**
* LSM303D constructor
*
* This driver only supports I2C.
*
* Due to the fact that this chip is currently obsolete, we only
* support minimum functionality.
*
* @param bus I2C bus to use
* @param addr The I2C address of the device
* @return The device context, or NULL if an error occurred
* @throws std::runtime_error on failure.
*/
  private LSM303D(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  private static long getCPtr(LSM303D obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  private void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        javaupm_lsm303dJNI.delete_LSM303D(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

/**
* LSM303D constructor
*
* This driver only supports I2C.
*
* Due to the fact that this chip is currently obsolete, we only
* support minimum functionality.
*
* @param bus I2C bus to use
* @param addr The I2C address of the device
* @return The device context, or NULL if an error occurred
* @throws std::runtime_error on failure.
*/
  public LSM303D(int bus, int addr) {
    this(javaupm_lsm303dJNI.new_LSM303D__SWIG_0(bus, addr), true);
  }

  public LSM303D(int bus) {
    this(javaupm_lsm303dJNI.new_LSM303D__SWIG_1(bus), true);
  }

  public LSM303D() {
    this(javaupm_lsm303dJNI.new_LSM303D__SWIG_2(), true);
  }

/**
* Update the internal stored values from sensor data.  This
* method must be called before querying the acceleration,
* magnetometer, or temperature.
*
* @throws std::runtime_error on failure
*/
  public void update() {
    javaupm_lsm303dJNI.LSM303D_update(swigCPtr, this);
  }

/**
* Return magnetometer data in micro-Teslas (uT) in the form
* of a floating point vector.  update() must have been called
* prior to calling this method.
*
* @return A floating point vector containing x, y, and z in
* that order
*/
  public floatVector getMagnetometer() {
    return new floatVector(javaupm_lsm303dJNI.LSM303D_getMagnetometer(swigCPtr, this), true);
  }

/**
* Return acceleration data in gravities in the form of a
* floating point vector.  update() must have been called
* prior to calling this method.
*
* @return A floating point vector containing x, y, and z in
* that order
*/
  public floatVector getAccelerometer() {
    return new floatVector(javaupm_lsm303dJNI.LSM303D_getAccelerometer(swigCPtr, this), true);
  }

/**
* Return temperature data in degrees Celsius.  NOTE: This is
* not the ambient room temperature.  update() must have been
* called prior to calling this method.
*
* @return Temperature in degrees Celsius
*/
  public float getTemperature() {
    return javaupm_lsm303dJNI.LSM303D_getTemperature(swigCPtr, this);
  }

/**
* Initialize the device and start operation.  This function
* is called from the constructor so it will not typically
* need to be called by a user unless the device is reset.  It
* will initialize the accelerometer and magnetometer (if
* enabled) to certain default running modes.
*
* @param res One of the LSM303D_M_RES_T values.  This value
* sets the resolution of the magnetometer.  At init time,
* this value is set to LSM303D_M_RES_HIGH.
* @throws std::runtime_error on failure
*/
  public void init(LSM303D_M_RES_T res) {
    javaupm_lsm303dJNI.LSM303D_init(swigCPtr, this, res.swigValue());
  }

/**
* Set the full scale (sensitivity) value for the
* accelerometer.  This device supports 2G, 4G, 6G, 8G, and
* 16G full scale modes.
*
* @param fs One of the LSM303D_AFS_T values
* @throws std::runtime_error on failure
*/
  public void setAccelerometerFullScale(LSM303D_AFS_T fs) {
    javaupm_lsm303dJNI.LSM303D_setAccelerometerFullScale(swigCPtr, this, fs.swigValue());
  }

/**
* Set the full scale (sensitivity) value for the
* magnetometer.  This device supports 2, 4, 8, and
* 16 Gauss full scale modes.
*
* @param fs One of the LSM303D_MFS_T values
* @throws std::runtime_error on failure
*/
  public void setMagnetometerFullScale(LSM303D_MFS_T fs) {
    javaupm_lsm303dJNI.LSM303D_setMagnetometerFullScale(swigCPtr, this, fs.swigValue());
  }

/**
* Set the accelerometer output data rate (ODR)
*
* @param odr One of the LSM303D_AODR_T values.  The default
* set at initialization time is LSM303D_AODR_100HZ.
* @throws std::runtime_error on failure
*/
  public void setAccelerometerODR(LSM303D_AODR_T odr) {
    javaupm_lsm303dJNI.LSM303D_setAccelerometerODR(swigCPtr, this, odr.swigValue());
  }

/**
* Set the magnetometer output data rate (ODR)
*
* @param odr One of the LSM303D_MODR_T values.
* The default set at initialization time is
* LSM303D_MODR_12_5HZ.
* @throws std::runtime_error on failure
*/
  public void setMagnetometerODR(LSM303D_MODR_T odr) {
    javaupm_lsm303dJNI.LSM303D_setMagnetometerODR(swigCPtr, this, odr.swigValue());
  }

}
