/* CXX header documentation injected w/doxyport */

/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.8
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

/**
* @brief XBee modules
* @defgroup xbee libupm-xbee
* @ingroup sparkfun uart wifi
*/
package upm_xbee;

/**
* @library xbee
* @sensor xbee
* @comname XBee Serial Module
* @type wifi
* @man sparkfun
* @con uart
* @web https://www.sparkfun.com/products/11215
*
* @brief API for the XBee modules
*
* This is a generic UART driver for use with Digi XBee modules.
* It was tested with the XBee S1 802.15.4 module and the XBee S6B
* WiFi module.
*
* It provides basic UART support for sending and receiving data
* to and from the device.  It is controlled by an AT or API
* command set.
*
* It is connected at 9600 baud by default.
*
* These devices are typically configured using Digi's X-CTU
* windows software, however it is possible of course to configure
* them manually using AT commands.  See the examples.
*
* @image html xbee.jpg
* <br><em>XBee Sensor image provided by SparkFun* under
* <a href=https://creativecommons.org/licenses/by-nc-sa/3.0/>
* CC BY-NC-SA-3.0</a>.</em>
*
* @snippet xbee.cxx Interesting
*/
public class XBee {
  private transient long swigCPtr;
  private transient boolean swigCMemOwn;

  private XBee(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  private static long getCPtr(XBee obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  private void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        javaupm_xbeeJNI.delete_XBee(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

/**
* XBee object constructor
*
* @param uart Default UART to use (0 or 1). Default is 0.
*/
  public XBee(int uart) {
    this(javaupm_xbeeJNI.new_XBee__SWIG_0(uart), true);
  }

  public XBee() {
    this(javaupm_xbeeJNI.new_XBee__SWIG_1(), true);
  }

/**
* Checks to see if there is data available for reading
*
* @param millis Number of milliseconds to wait; 0 means no waiting
* @return true if there is data available for reading
*/
  public boolean dataAvailable(long millis) {
    return javaupm_xbeeJNI.XBee_dataAvailable(swigCPtr, this, millis);
  }

/**
* Reads any available data into a user-supplied buffer. Note: the
* call blocks until data is available for reading. Use
* dataAvailable() to determine whether there is data available
* beforehand, to avoid blocking.
*
* @param buffer Buffer to hold the data read
* @param len Length of the buffer
* @return Number of bytes read
*/
  public int readData(String buffer, long len) {
    return javaupm_xbeeJNI.XBee_readData(swigCPtr, this, buffer, len);
  }

/**
* Reads any available data and returns it in a std::string. Note:
* the call blocks until data is available for reading. Use
* dataAvailable() to determine whether there is data available
* beforehand, to avoid blocking.
*
* @param len Maximum length of the data to be returned
* @return string containing the data read
*/
  public String readDataStr(int len) {
    return javaupm_xbeeJNI.XBee_readDataStr(swigCPtr, this, len);
  }

/**
* Writes the data in the buffer to the device.  If you are
* writing an AT command, be sure to terminate it with a carriage
* return (\r)
*
* @param buffer Buffer to hold the data to write
* @param len Length of the buffer
* @return Number of bytes written
*/
  public int writeData(String buffer, long len) {
    return javaupm_xbeeJNI.XBee_writeData(swigCPtr, this, buffer, len);
  }

/**
* Writes the std:string data to the device.  If you are writing an
* AT command, be sure to terminate it with a carriage return (\r)
*
* @param data Buffer to write to the device
* @return Number of bytes written
*/
  public int writeDataStr(String data) {
    return javaupm_xbeeJNI.XBee_writeDataStr(swigCPtr, this, data);
  }

/**
* Sets the baud rate for the device.  The default is 9600.
*
* @param baud Desired baud rate
* @return true if successful
*/
  public int setBaudRate(int baud) {
    return javaupm_xbeeJNI.XBee_setBaudRate__SWIG_0(swigCPtr, this, baud);
  }

  public int setBaudRate() {
    return javaupm_xbeeJNI.XBee_setBaudRate__SWIG_1(swigCPtr, this);
  }

/**
* Attempts to enter AT Command Mode.  When Idle, data sent to the
* device (assuming it is not in API mode) is silently transmitted
* to the configured destination.  Running this command attempts
* to place the device into command mode, allowing you to send AT
* commands.  Note, after a configurable period of inactivity, the
* device will exit command mode automatically (default 10
* seconds).
*
* Both the cmdChars (+++) and the Guard Time can be configured
* on the device to different values using AT configuration
* commands.
*
* @param cmdChars The command mode characters, default "+++"
* @param guardTimeMS The number of milliseconds to wait before and
* after sending the command characters.  Default is 1000 (1 second).
* @return true if successful (received an "OK"), false otherwise
*/
  public boolean commandMode(String cmdChars, int guardTimeMS) {
    return javaupm_xbeeJNI.XBee_commandMode__SWIG_0(swigCPtr, this, cmdChars, guardTimeMS);
  }

  public boolean commandMode(String cmdChars) {
    return javaupm_xbeeJNI.XBee_commandMode__SWIG_1(swigCPtr, this, cmdChars);
  }

  public boolean commandMode() {
    return javaupm_xbeeJNI.XBee_commandMode__SWIG_2(swigCPtr, this);
  }

/**
* This is a convenience method that converts each CR (\r) in a
* string to a LF (\n) and returns it.  This is useful for
* outputting the response to an AT command for instance, which is
* typically CR terminated.
*
* @param str The string to convert
* @return The converted string
*/
  public String stringCR2LF(String str) {
    return javaupm_xbeeJNI.XBee_stringCR2LF(swigCPtr, this, str);
  }

}
