/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rpc.model.message;

import io.nuls.core.constant.ErrorCode;
import io.nuls.core.model.DateUtils;
import io.nuls.core.rpc.info.Constants;
import io.nuls.core.rpc.model.message.Message;
import io.nuls.core.rpc.model.message.MessageType;
import io.nuls.core.rpc.model.message.NegotiateConnection;
import io.nuls.core.rpc.model.message.Request;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.channel.manager.ConnectManager;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MessageUtil {
    public static Message basicMessage(MessageType messageType) {
        Message message = new Message();
        message.setMessageID(Constants.nextSequence());
        message.setMessageType(messageType.name());
        message.setTimestamp(String.valueOf(NulsDateUtils.getCurrentTimeMillis()));
        message.setTimeZone(DateUtils.TIME_ZONE_STRING);
        return message;
    }

    public static NegotiateConnection defaultNegotiateConnection() {
        NegotiateConnection negotiateConnection = new NegotiateConnection();
        negotiateConnection.setAbbreviation(ConnectManager.LOCAL.getAbbreviation());
        negotiateConnection.setProtocolVersion("0.1");
        negotiateConnection.setCompressionAlgorithm("zlib");
        negotiateConnection.setCompressionRate("0");
        return negotiateConnection;
    }

    public static Request defaultRequest() {
        Request request = new Request();
        request.setRequestAck("0");
        request.setSubscriptionEventCounter("0");
        request.setSubscriptionPeriod("0");
        request.setSubscriptionRange("0");
        request.setResponseMaxSize("0");
        request.setRequestMethods(new HashMap<String, Object>(1));
        return request;
    }

    public static Request newRequest(String cmd, Map params, String ack, String subscriptionPeriod, String subscriptionEventCounter) {
        Request request = MessageUtil.defaultRequest();
        request.setRequestAck(ack);
        request.setSubscriptionPeriod(subscriptionPeriod);
        request.setSubscriptionEventCounter(subscriptionEventCounter);
        request.getRequestMethods().put(cmd, params);
        return request;
    }

    public static Response newResponse(String requestId, int status, String comment) {
        Response response = new Response();
        response.setRequestID(requestId);
        response.setResponseStatus(status);
        response.setResponseComment(comment);
        response.setResponseMaxSize("0");
        return response;
    }

    public static Response newSuccessResponse(String requestId) {
        return MessageUtil.newResponse(requestId, 0, "success");
    }

    public static Response newSuccessResponse(String requestId, String msg) {
        return MessageUtil.newResponse(requestId, 0, msg);
    }

    public static Response newFailResponse(String requestId, String msg) {
        return MessageUtil.newResponse(requestId, 65536, msg);
    }

    public static Response newFailResponse(String requestId, ErrorCode errorCode) {
        Objects.requireNonNull(errorCode, "errorCode can't be null");
        Response response = MessageUtil.newFailResponse(requestId, errorCode.getMsg());
        response.setResponseErrorCode(errorCode.getCode());
        return response;
    }
}

