/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rpc.netty.channel.manager;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import io.nuls.core.core.ioc.ScanUtil;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.invoke.BaseInvoke;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.CmdDetail;
import io.nuls.core.rpc.model.CmdParameter;
import io.nuls.core.rpc.model.ConfigItem;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.RegisterApi;
import io.nuls.core.rpc.model.message.Message;
import io.nuls.core.rpc.model.message.Request;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.bootstrap.NettyClient;
import io.nuls.core.rpc.netty.channel.ConnectData;
import io.nuls.core.rpc.netty.processor.RequestMessageProcessor;
import io.nuls.core.rpc.netty.thread.RequestByCountProcessor;
import io.nuls.core.rpc.netty.thread.RequestByPeriodProcessor;
import io.nuls.core.rpc.netty.thread.RequestOnlyProcessor;
import io.nuls.core.rpc.netty.thread.ResponseAutoProcessor;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ConnectManager {
    private static Lock SUB_LOCK = new ReentrantLock();
    public static boolean startService = false;
    public static final RegisterApi LOCAL = new RegisterApi();
    public static final Map<String, Integer> CMD_PRIORITY_MAP = new ConcurrentHashMap<String, Integer>();
    public static final Map<String, ConfigItem> CONFIG_ITEM_MAP = new ConcurrentHashMap<String, ConfigItem>();
    public static final Map<String, Map> ROLE_MAP = new ConcurrentHashMap<String, Map>();
    public static final Map<String, BaseInvoke> INVOKE_MAP = new ConcurrentHashMap<String, BaseInvoke>();
    public static final Map<Channel, ConnectData> CHANNEL_DATA_MAP = new ConcurrentHashMap<Channel, ConnectData>();
    public static final Map<String, Channel> ROLE_CHANNEL_MAP = new ConcurrentHashMap<String, Channel>();
    public static final ConcurrentMap<String, Channel> MSG_ID_KEY_CHANNEL_MAP = new ConcurrentHashMap<String, Channel>();
    public static final Map<String, CopyOnWriteArrayList<Message>> CMD_SUBSCRIBE_MESSAGE_MAP = new ConcurrentHashMap<String, CopyOnWriteArrayList<Message>>();
    public static final Map<Message, ConnectData> MESSAGE_TO_CHANNEL_MAP = new ConcurrentHashMap<Message, ConnectData>();
    public static final Map<String, Integer> SUBSCRIBE_COUNT = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Integer> CMD_CHANGE_COUNT = new ConcurrentHashMap<String, Integer>();
    public static int subRequestCount = 0;

    public static CmdDetail getLocalInvokeCmd(String cmd, double minVersion) {
        CmdDetail find = null;
        for (CmdDetail cmdDetail : LOCAL.getMethods()) {
            if (!cmdDetail.getMethodName().equals(cmd) || (int)minVersion != (int)cmdDetail.getVersion()) continue;
            if (find == null) {
                find = cmdDetail;
                continue;
            }
            if (!(cmdDetail.getVersion() > find.getVersion())) continue;
            find = cmdDetail;
        }
        return find;
    }

    public static CmdDetail getLocalInvokeCmd(String cmd) {
        CmdDetail find = null;
        for (CmdDetail cmdDetail : LOCAL.getMethods()) {
            if (!cmdDetail.getMethodName().equals(cmd)) continue;
            if (find == null) {
                find = cmdDetail;
                continue;
            }
            if (!(cmdDetail.getVersion() > find.getVersion())) continue;
            find = cmdDetail;
        }
        return find;
    }

    public static void scanPackage(Set<String> packageName) throws Exception {
        if (packageName == null || packageName.size() == 0) {
            return;
        }
        HashSet classes = new HashSet();
        packageName.forEach(pack -> classes.addAll(ScanUtil.scan((String)pack)));
        for (Class clz : classes) {
            Method[] methods;
            for (Method method : methods = clz.getDeclaredMethods()) {
                CmdDetail cmdDetail = ConnectManager.annotation2CmdDetail(method);
                if (cmdDetail == null) continue;
                if (!ConnectManager.isRegister(cmdDetail)) {
                    LOCAL.getMethods().add(cmdDetail);
                    RequestMessageProcessor.handlerMap.put(cmdDetail.getInvokeClass(), SpringLiteContext.getBeanByClass((String)cmdDetail.getInvokeClass()));
                    Log.debug((String)("valid cmdDetail-" + cmdDetail));
                    continue;
                }
                throw new Exception("Duplicate cmd found:" + cmdDetail.getMethodName() + "-" + cmdDetail.getVersion());
            }
        }
        LOCAL.getMethods().sort(Comparator.comparingDouble(CmdDetail::getVersion));
    }

    public static void addCmdDetail(Class<?> claszs) {
        Method[] methods;
        for (Method method : methods = claszs.getDeclaredMethods()) {
            CmdDetail cmdDetail = ConnectManager.annotation2CmdDetail(method);
            if (cmdDetail == null || ConnectManager.isRegister(cmdDetail)) continue;
            LOCAL.getMethods().add(cmdDetail);
            RequestMessageProcessor.handlerMap.put(cmdDetail.getInvokeClass(), SpringLiteContext.getBeanByClass((String)cmdDetail.getInvokeClass()));
        }
    }

    private static CmdDetail annotation2CmdDetail(Method method) {
        Annotation[] annotations;
        CmdDetail cmdDetail = null;
        ArrayList<CmdParameter> cmdParameters = new ArrayList<CmdParameter>();
        for (Annotation annotation : annotations = method.getDeclaredAnnotations()) {
            if (annotation instanceof CmdAnnotation) {
                CmdAnnotation cmdAnnotation = (CmdAnnotation)annotation;
                cmdDetail = new CmdDetail();
                cmdDetail.setMethodName(cmdAnnotation.cmd());
                cmdDetail.setMethodDescription(cmdAnnotation.description());
                cmdDetail.setMethodMinEvent("" + cmdAnnotation.minEvent());
                cmdDetail.setMethodMinPeriod("" + cmdAnnotation.minPeriod());
                cmdDetail.setMethodScope(cmdAnnotation.scope());
                cmdDetail.setVersion(cmdAnnotation.version());
                cmdDetail.setPriority(cmdAnnotation.priority());
                cmdDetail.setInvokeClass(method.getDeclaringClass().getName());
                cmdDetail.setInvokeMethod(method.getName());
                CMD_PRIORITY_MAP.put(cmdAnnotation.cmd(), cmdAnnotation.priority().getPriority());
                continue;
            }
            if (annotation instanceof Parameter) {
                Parameter parameter = (Parameter)annotation;
                CmdParameter cmdParameter = new CmdParameter(parameter.parameterName(), parameter.parameterType(), parameter.parameterValidRange(), parameter.parameterValidRegExp());
                cmdParameters.add(cmdParameter);
                continue;
            }
            if (!(annotation instanceof Parameters)) continue;
            Parameters parameters = (Parameters)annotation;
            for (Parameter parameter : parameters.value()) {
                CmdParameter cmdParameter = new CmdParameter(parameter.parameterName(), parameter.parameterType(), parameter.parameterValidRange(), parameter.parameterValidRegExp());
                cmdParameters.add(cmdParameter);
            }
        }
        if (cmdDetail == null) {
            return null;
        }
        cmdDetail.setParameters(cmdParameters);
        return cmdDetail;
    }

    private static boolean isRegister(CmdDetail sourceCmdDetail) {
        boolean exist = false;
        for (CmdDetail cmdDetail : LOCAL.getMethods()) {
            if (!cmdDetail.getMethodName().equals(sourceCmdDetail.getMethodName()) || cmdDetail.getVersion() != sourceCmdDetail.getVersion()) continue;
            exist = true;
            break;
        }
        return exist;
    }

    public static int addCmdChangeCount(String cmd) {
        int count = 1;
        if (!CMD_CHANGE_COUNT.containsKey(cmd)) {
            CMD_CHANGE_COUNT.put(cmd, count);
        } else {
            count = CMD_CHANGE_COUNT.get(cmd) + 1;
            CMD_CHANGE_COUNT.put(cmd, count);
        }
        return count;
    }

    public static int getCmdChangeCount(String cmd) {
        Integer integer = CMD_CHANGE_COUNT.get(cmd);
        return integer == null ? 1 : integer;
    }

    public static void subscribeCountMinus(String cmd) {
        if (SUBSCRIBE_COUNT.containsKey(cmd)) {
            int count = SUBSCRIBE_COUNT.get(cmd) - 1;
            if (count <= 0) {
                SUBSCRIBE_COUNT.remove(cmd);
                CMD_CHANGE_COUNT.remove(cmd);
                return;
            }
            SUBSCRIBE_COUNT.put(cmd, count);
        }
    }

    public static void subscribeCountMinus(Message message) {
        Request request = (Request)JSONUtils.map2pojo((Map)((Map)message.getMessageData()), Request.class);
        Iterator<String> iterator = request.getRequestMethods().keySet().iterator();
        while (iterator.hasNext()) {
            String method;
            String cmd = method = iterator.next();
            ConnectManager.subscribeCountMinus(cmd);
        }
    }

    public static void subscribeCountAdd(String cmd) {
        if (!SUBSCRIBE_COUNT.containsKey(cmd)) {
            SUBSCRIBE_COUNT.put(cmd, 1);
            return;
        }
        int count = SUBSCRIBE_COUNT.get(cmd) + 1;
        SUBSCRIBE_COUNT.put(cmd, count);
    }

    public static void subscribeCountAdd(Message message) {
        Request request = (Request)JSONUtils.map2pojo((Map)((Map)message.getMessageData()), Request.class);
        Iterator<String> iterator = request.getRequestMethods().keySet().iterator();
        while (iterator.hasNext()) {
            String method;
            String cmd = method = iterator.next();
            ConnectManager.subscribeCountAdd(cmd);
        }
    }

    public static void subscribeByEvent(ConnectData connectData, Message message, Request request) {
        MESSAGE_TO_CHANNEL_MAP.put(message, connectData);
        for (String method : request.getRequestMethods().keySet()) {
            if (CMD_SUBSCRIBE_MESSAGE_MAP.containsKey(method)) {
                CMD_SUBSCRIBE_MESSAGE_MAP.get(method).add(message);
            } else {
                CopyOnWriteArrayList<Message> messageList = new CopyOnWriteArrayList<Message>();
                messageList.add(message);
                CMD_SUBSCRIBE_MESSAGE_MAP.put(method, messageList);
            }
            ConnectManager.subscribeCountAdd(method);
        }
    }

    public static void unsubscribeByEvent(Message message) {
        MESSAGE_TO_CHANNEL_MAP.remove(message);
        Request request = (Request)JSONUtils.map2pojo((Map)((Map)message.getMessageData()), Request.class);
        for (String method : request.getRequestMethods().keySet()) {
            if (CMD_SUBSCRIBE_MESSAGE_MAP.containsKey(method)) {
                CMD_SUBSCRIBE_MESSAGE_MAP.get(method).remove(message);
            }
            ConnectManager.subscribeCountMinus(method);
        }
    }

    public static void eventTrigger(String cmd, Response response) {
        try {
            CopyOnWriteArrayList<Message> messageList = CMD_SUBSCRIBE_MESSAGE_MAP.get(cmd);
            if (messageList == null) {
                return;
            }
            int changeCount = ConnectManager.addCmdChangeCount(cmd);
            for (Message message : messageList) {
                Request request;
                long eventCount;
                int initCount;
                ConnectData connectData = MESSAGE_TO_CHANNEL_MAP.get(message);
                String key = ConnectManager.getSubscribeKey(message.getMessageID(), cmd);
                if (!connectData.getSubscribeInitCount().containsKey(key) || (long)(changeCount - (initCount = connectData.getSubscribeInitCount().get(key).intValue())) % (eventCount = Long.parseLong((request = (Request)JSONUtils.map2pojo((Map)((Map)message.getMessageData()), Request.class)).getSubscriptionEventCounter())) != 0L) continue;
                try {
                    connectData.getRequestEventResponseQueue().put(ConnectManager.getRealResponse(cmd, message.getMessageID(), response));
                }
                catch (InterruptedException e) {
                    Log.error((Throwable)e);
                }
            }
        }
        catch (Exception e) {
            Log.error((Throwable)e);
        }
    }

    public static Response getRealResponse(String cmd, String messageId, Response response) {
        Response realResponse = new Response();
        realResponse.setRequestID(messageId);
        realResponse.setResponseStatus(response.getResponseStatus());
        realResponse.setResponseComment(response.getResponseComment());
        realResponse.setResponseMaxSize(response.getResponseMaxSize());
        realResponse.setResponseData(response.getResponseData());
        realResponse.setResponseErrorCode(response.getResponseErrorCode());
        return realResponse;
    }

    public static String getSubscribeKey(String messageId, String cmd) {
        return cmd + "_" + messageId;
    }

    public static void updateStatus() {
        if (!startService) {
            Map<String, String> dependencies = LOCAL.getDependencies();
            if (dependencies != null && dependencies.size() > 0) {
                for (String role : LOCAL.getDependencies().keySet()) {
                    if (ROLE_MAP.containsKey(role)) continue;
                    return;
                }
            }
            startService = true;
        }
    }

    public static boolean isReady() {
        return startService;
    }

    public static String getRemoteUri(String role) {
        Map map = ROLE_MAP.get(role);
        return map == null ? null : "ws://" + map.get("IP") + ":" + map.get("Port") + "/ws";
    }

    public static String getRemoteUri(SocketChannel channel) {
        return "ws://" + channel.remoteAddress().getHostString() + ":" + channel.remoteAddress().getPort() + "/ws";
    }

    public static ConnectData getConnectDataByRole(String role) throws Exception {
        Channel channel = ROLE_CHANNEL_MAP.get(role);
        if (ROLE_CHANNEL_MAP.isEmpty() || channel == null) {
            String url = ConnectManager.getRemoteUri(role);
            if (StringUtils.isBlank((String)url)) {
                throw new Exception("Connection module not started");
            }
            channel = ConnectManager.getConnectByUrl(role);
        }
        return CHANNEL_DATA_MAP.get(channel);
    }

    public static Channel getConnectByRole(String role) throws Exception {
        if (ROLE_CHANNEL_MAP.containsKey(role)) {
            return ROLE_CHANNEL_MAP.get(role);
        }
        String url = ConnectManager.getRemoteUri(role);
        if (StringUtils.isBlank((String)url)) {
            throw new Exception("Connection module not started:" + role);
        }
        Channel channel = ConnectManager.createConnect(url);
        channel = ConnectManager.cacheConnect(role, channel, true);
        return channel;
    }

    public static Channel getConnectByUrl(String url) throws Exception {
        String role = "";
        for (String key : ROLE_MAP.keySet()) {
            if (!url.equals(ConnectManager.getRemoteUri(key))) continue;
            role = key;
            break;
        }
        if (role.isEmpty() && ROLE_CHANNEL_MAP.isEmpty() && !ROLE_MAP.isEmpty()) {
            throw new Exception("Connection module not started");
        }
        if (role.isEmpty()) {
            role = ModuleE.KE.abbr;
        }
        if (ROLE_CHANNEL_MAP.containsKey(role)) {
            return ROLE_CHANNEL_MAP.get(role);
        }
        Channel channel = ConnectManager.createConnect(url);
        channel = ConnectManager.cacheConnect(role, channel, true);
        return channel;
    }

    public static Channel createConnect(String url) throws Exception {
        Channel channel = NettyClient.createConnect(url);
        long start = NulsDateUtils.getCurrentTimeMillis();
        while (channel == null || !channel.isOpen()) {
            if (NulsDateUtils.getCurrentTimeMillis() - start > 5000L) {
                throw new Exception("Failed to connect " + url);
            }
            Thread.sleep(1L);
        }
        return channel;
    }

    public static void createConnectData(Channel channel) {
        ConnectData connectData = new ConnectData((SocketChannel)channel);
        connectData.getThreadPool().execute(new RequestByPeriodProcessor(connectData));
        connectData.getThreadPool().execute(new RequestByCountProcessor(connectData));
        connectData.getThreadPool().execute(new ResponseAutoProcessor(connectData));
        connectData.getThreadPool().execute(new ResponseAutoProcessor(connectData));
        connectData.getThreadPool().execute(new RequestOnlyProcessor(connectData));
        connectData.getThreadPool().execute(new RequestOnlyProcessor(connectData));
        CHANNEL_DATA_MAP.put(channel, connectData);
    }

    public static void disConnect(SocketChannel channel) {
        if (!ROLE_CHANNEL_MAP.values().contains(channel)) {
            return;
        }
        Iterator<Map.Entry<String, Channel>> entries = ROLE_CHANNEL_MAP.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, Channel> entry = entries.next();
            if (!channel.equals(entry.getValue())) continue;
            entries.remove();
            break;
        }
        Iterator msgEntries = MSG_ID_KEY_CHANNEL_MAP.entrySet().iterator();
        while (msgEntries.hasNext()) {
            Map.Entry entry = msgEntries.next();
            if (!channel.equals(entry.getValue())) continue;
            INVOKE_MAP.remove(entry.getKey());
            msgEntries.remove();
        }
        ConnectData connectData = CHANNEL_DATA_MAP.remove(channel);
        connectData.setConnected(false);
        connectData.getThreadPool().shutdown();
        channel.close();
    }

    public static boolean isPureDigital(String string) {
        try {
            return Integer.parseInt(string) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void sendMessage(Channel channel, String message) {
        try {
            channel.eventLoop().execute(() -> {
                ChannelFuture cf = channel.writeAndFlush((Object)new TextWebSocketFrame(message));
                cf.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            Log.error((Throwable)future.cause());
                        }
                    }
                });
            });
        }
        catch (Exception e) {
            Log.error((Throwable)e);
        }
    }

    public static void sendMessage(String moduleAbbr, Message message) throws Exception {
        ConnectManager.sendMessage(ConnectManager.getConnectByRole(moduleAbbr), JSONUtils.obj2json((Object)message));
    }

    public static synchronized Channel cacheConnect(String role, Channel channel, boolean isSender) {
        if (!ROLE_CHANNEL_MAP.containsKey(role) || isSender && role.compareTo(LOCAL.getAbbreviation()) > 0 || !isSender && role.compareTo(LOCAL.getAbbreviation()) < 0) {
            ConnectManager.createConnectData(channel);
            ROLE_CHANNEL_MAP.put(role, channel);
            return channel;
        }
        return ROLE_CHANNEL_MAP.get(role);
    }
}

