/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rpc.netty.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.info.Constants;
import io.nuls.core.rpc.model.CmdPriority;
import io.nuls.core.rpc.model.message.Message;
import io.nuls.core.rpc.model.message.MessageType;
import io.nuls.core.rpc.model.message.Request;
import io.nuls.core.rpc.netty.channel.manager.ConnectManager;
import io.nuls.core.rpc.netty.handler.message.TextMessageHandler;
import io.nuls.core.thread.commom.NulsThreadFactory;
import java.util.Map;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ServerHandler
extends SimpleChannelInboundHandler<Object> {
    private ThreadPoolExecutor requestExecutorService = new ThreadPoolExecutor(Constants.THREAD_POOL_SIZE, Constants.THREAD_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(), (ThreadFactory)new NulsThreadFactory("server-handler-request"));
    private ThreadPoolExecutor responseExecutorService = new ThreadPoolExecutor(Constants.THREAD_POOL_SIZE, Constants.THREAD_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(), (ThreadFactory)new NulsThreadFactory("server-handler-request"));

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof TextWebSocketFrame) {
            TextWebSocketFrame txMsg = (TextWebSocketFrame)msg;
            Message message = (Message)JSONUtils.json2pojo((String)txMsg.text(), Message.class);
            MessageType messageType = MessageType.valueOf(message.getMessageType());
            int priority = CmdPriority.DEFAULT.getPriority();
            TextMessageHandler messageHandler = new TextMessageHandler((SocketChannel)ctx.channel(), message, priority);
            if (this.requestExecutorService.getQueue().size() >= 500 || this.responseExecutorService.getQueue().size() > 500) {
                Log.info((String)"\u5f53\u524d\u8bf7\u6c42\u7ebf\u7a0b\u6c60\u603b\u7ebf\u7a0b\u6570\u91cf{},\u8fd0\u884c\u4e2d\u7ebf\u7a0b\u6570\u91cf{},\u7b49\u5f85\u961f\u5217\u6570\u91cf{}", (Object[])new Object[]{this.requestExecutorService.getPoolSize(), this.requestExecutorService.getActiveCount(), this.requestExecutorService.getQueue().size()});
                Log.info((String)"\u5f53\u524d\u54cd\u5e94\u7ebf\u7a0b\u6c60\u603b\u7ebf\u7a0b\u6570\u91cf{},\u8fd0\u884c\u4e2d\u7ebf\u7a0b\u6570\u91cf{},\u7b49\u5f85\u961f\u5217\u6570\u91cf{}", (Object[])new Object[]{this.responseExecutorService.getPoolSize(), this.responseExecutorService.getActiveCount(), this.responseExecutorService.getQueue().size()});
            }
            if (messageType.equals((Object)MessageType.Response) || messageType.equals((Object)MessageType.NegotiateConnectionResponse) || messageType.equals((Object)MessageType.Ack)) {
                this.responseExecutorService.execute(messageHandler);
            } else {
                if (messageType.equals((Object)MessageType.Request)) {
                    Request request = (Request)JSONUtils.map2pojo((Map)((Map)message.getMessageData()), Request.class);
                    if (request.getRequestMethods().size() == 1) {
                        for (String cmd : request.getRequestMethods().keySet()) {
                            if (!ConnectManager.CMD_PRIORITY_MAP.containsKey(cmd)) continue;
                            messageHandler.setPriority(ConnectManager.CMD_PRIORITY_MAP.get(cmd));
                        }
                    }
                    messageHandler.setRequest(request);
                }
                this.requestExecutorService.execute(messageHandler);
            }
        } else {
            Log.warn((String)"Unsupported message format");
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ConnectManager.disConnect((SocketChannel)ctx.channel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        cause.printStackTrace();
    }
}

