/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rpc.netty.processor;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.channel.Channel;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdDetail;
import io.nuls.core.rpc.model.CmdParameter;
import io.nuls.core.rpc.model.message.Ack;
import io.nuls.core.rpc.model.message.Message;
import io.nuls.core.rpc.model.message.MessageType;
import io.nuls.core.rpc.model.message.MessageUtil;
import io.nuls.core.rpc.model.message.NegotiateConnection;
import io.nuls.core.rpc.model.message.NegotiateConnectionResponse;
import io.nuls.core.rpc.model.message.Request;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.model.message.Unsubscribe;
import io.nuls.core.rpc.netty.channel.ConnectData;
import io.nuls.core.rpc.netty.channel.manager.ConnectManager;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RequestMessageProcessor {
    public static final Map<String, Object> handlerMap = new HashMap<String, Object>();
    public static final Map<String, Class<?>> classMap = new ConcurrentHashMap();

    public static void negotiateConnectionResponse(Channel channel, Message message) throws JsonProcessingException {
        NegotiateConnectionResponse negotiateConnectionResponse = new NegotiateConnectionResponse();
        negotiateConnectionResponse.setRequestID(message.getMessageID());
        negotiateConnectionResponse.setNegotiationStatus("1");
        negotiateConnectionResponse.setNegotiationComment("Connection true!");
        Message rspMsg = MessageUtil.basicMessage(MessageType.NegotiateConnectionResponse);
        rspMsg.setMessageData(negotiateConnectionResponse);
        ConnectManager.sendMessage(channel, JSONUtils.obj2json((Object)rspMsg));
        NegotiateConnection negotiateConnection = (NegotiateConnection)JSONUtils.map2pojo((Map)((Map)message.getMessageData()), NegotiateConnection.class);
        ConnectManager.cacheConnect(negotiateConnection.getAbbreviation(), channel, false);
    }

    public static void ack(Channel channel, String messageId) throws JsonProcessingException {
        Ack ack = new Ack();
        ack.setRequestId(messageId);
        Message rspMsg = MessageUtil.basicMessage(MessageType.Ack);
        rspMsg.setMessageData(ack);
        ConnectManager.sendMessage(channel, JSONUtils.obj2json((Object)rspMsg));
    }

    public static void serviceNotStarted(Channel channel, String messageId) throws JsonProcessingException {
        Response response = MessageUtil.newFailResponse(messageId, "Service not started!");
        Message rspMsg = MessageUtil.basicMessage(MessageType.Response);
        rspMsg.setMessageData(response);
        ConnectManager.sendMessage(channel, JSONUtils.obj2json((Object)rspMsg));
    }

    public static synchronized void unsubscribe(ConnectData channelData, Message message) {
        Unsubscribe unsubscribe = (Unsubscribe)JSONUtils.map2pojo((Map)((Map)message.getMessageData()), Unsubscribe.class);
        for (String requestId : unsubscribe.getUnsubscribeMethods()) {
            channelData.unsubscribe(requestId);
        }
    }

    public static boolean responseWithPeriod(ConnectData channelData, Message message, Request request) {
        int nextProcess = RequestMessageProcessor.nextProcess(channelData, message, Integer.parseInt(request.getSubscriptionPeriod()));
        try {
            switch (nextProcess) {
                case 1: {
                    RequestMessageProcessor.callCommandsWithPeriod((Channel)channelData.getChannel(), request.getRequestMethods(), message.getMessageID(), false);
                    channelData.getCmdInvokeTime().put(message, NulsDateUtils.getCurrentTimeMillis());
                    return true;
                }
                case 2: {
                    RequestMessageProcessor.callCommandsWithPeriod((Channel)channelData.getChannel(), request.getRequestMethods(), message.getMessageID(), false);
                    channelData.getCmdInvokeTime().put(message, NulsDateUtils.getCurrentTimeMillis());
                    return false;
                }
                case 3: {
                    return true;
                }
                case 4: {
                    return false;
                }
            }
            return false;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    public static void callCommandsWithPeriod(Channel channel, Map requestMethods, String messageId, boolean isSubscribe) throws JsonProcessingException {
        Iterator iterator = requestMethods.entrySet().iterator();
        while (iterator.hasNext()) {
            Message rspMessage;
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            String method = (String)entry.getKey();
            Map params = (Map)entry.getValue();
            Response response = MessageUtil.newResponse(messageId, 65536, "");
            try {
                Message rspMessage2;
                CmdDetail cmdDetail;
                CmdDetail cmdDetail2 = cmdDetail = params == null || params.get("version") == null ? ConnectManager.getLocalInvokeCmd(method) : ConnectManager.getLocalInvokeCmd(method, Double.parseDouble(params.get("version").toString()));
                if (cmdDetail == null) {
                    response.setResponseComment("Cmd not found:" + method + "," + (params != null ? params.get("version") : ""));
                    response.setResponseErrorCode(CommonCodeConstanst.CMD_NOTFOUND.getCode());
                    rspMessage = MessageUtil.basicMessage(MessageType.Response);
                    rspMessage.setMessageData(response);
                    ConnectManager.sendMessage(channel, JSONUtils.obj2json((Object)rspMessage));
                    return;
                }
                String validationString = RequestMessageProcessor.paramsValidation(cmdDetail, params);
                if (validationString != null) {
                    response.setResponseComment(validationString);
                    response.setResponseErrorCode(CommonCodeConstanst.PARAMETER_ERROR.getCode());
                    rspMessage2 = MessageUtil.basicMessage(MessageType.Response);
                    rspMessage2.setMessageData(response);
                    ConnectManager.sendMessage(channel, JSONUtils.obj2json((Object)rspMessage2));
                    return;
                }
                rspMessage2 = RequestMessageProcessor.execute(cmdDetail, params, messageId);
                ConnectManager.sendMessage(channel, JSONUtils.obj2json((Object)rspMessage2));
                if (!ConnectManager.SUBSCRIBE_COUNT.containsKey(method) || !isSubscribe) continue;
                ConnectManager.eventTrigger(method, (Response)rspMessage2.getMessageData());
            }
            catch (Exception e) {
                Log.error((Throwable)e);
                response.setResponseComment("Server-side processing failed!");
                response.setResponseErrorCode(CommonCodeConstanst.SYS_UNKOWN_EXCEPTION.getCode());
                rspMessage = MessageUtil.basicMessage(MessageType.Response);
                rspMessage.setMessageData(response);
                ConnectManager.sendMessage(channel, JSONUtils.obj2json((Object)rspMessage));
            }
        }
    }

    public static void callCommands(Map requestMethods) throws JsonProcessingException {
        Iterator iterator = requestMethods.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            String method = (String)entry.getKey();
            Map params = (Map)entry.getValue();
            try {
                CmdDetail cmdDetail;
                CmdDetail cmdDetail2 = cmdDetail = params == null || params.get("version") == null ? ConnectManager.getLocalInvokeCmd(method) : ConnectManager.getLocalInvokeCmd(method, Double.parseDouble(params.get("version").toString()));
                if (cmdDetail == null) {
                    Log.info((String)"Call method does not exist!");
                    return;
                }
                String validationString = RequestMessageProcessor.paramsValidation(cmdDetail, params);
                if (validationString != null) {
                    Log.info((String)"Parameter validation error!");
                    return;
                }
                RequestMessageProcessor.invoke(cmdDetail.getInvokeClass(), cmdDetail.getInvokeMethod(), params);
            }
            catch (Exception e) {
                Log.error((Throwable)e);
            }
        }
    }

    private static Message execute(CmdDetail cmdDetail, Map params, String messageId) throws Exception {
        long startTimemillis = NulsDateUtils.getCurrentTimeMillis();
        Response response = RequestMessageProcessor.invoke(cmdDetail.getInvokeClass(), cmdDetail.getInvokeMethod(), params);
        response.setRequestID(messageId);
        HashMap<String, Object> responseData = new HashMap<String, Object>(1);
        responseData.put(cmdDetail.getMethodName(), response.getResponseData());
        response.setResponseData(responseData);
        response.setResponseProcessingTime("" + (NulsDateUtils.getCurrentTimeMillis() - startTimemillis));
        Message rspMessage = MessageUtil.basicMessage(MessageType.Response);
        rspMessage.setMessageData(response);
        return rspMessage;
    }

    public static void responseWithEventCount(Channel channel, Response realResponse) {
        Message rspMessage = MessageUtil.basicMessage(MessageType.Response);
        rspMessage.setMessageData(realResponse);
        try {
            Log.debug((String)("responseWithEventCount: " + JSONUtils.obj2json((Object)rspMessage)));
            ConnectManager.sendMessage(channel, JSONUtils.obj2json((Object)rspMessage));
        }
        catch (JsonProcessingException e) {
            Log.error((Throwable)e);
        }
    }

    private static int nextProcess(ConnectData channelData, Message message, int subscriptionPeriod) {
        if (subscriptionPeriod == 0) {
            return 2;
        }
        if (!channelData.getCmdInvokeTime().containsKey(message)) {
            channelData.getCmdInvokeTime().put(message, 0L);
        }
        if (NulsDateUtils.getCurrentTimeMillis() - channelData.getCmdInvokeTime().get(message) < (long)subscriptionPeriod * 1000L) {
            return 3;
        }
        return 1;
    }

    private static String paramsValidation(CmdDetail cmdDetail, Map params) {
        List<CmdParameter> cmdParameterList = cmdDetail.getParameters();
        for (CmdParameter cmdParameter : cmdParameterList) {
            if (!(StringUtils.isNull((String)cmdParameter.getParameterValidRange()) && StringUtils.isNull((String)cmdParameter.getParameterValidRegExp()) || params != null && params.get(cmdParameter.getParameterName()) != null)) {
                return "Param null:" + cmdParameter.getParameterName();
            }
            if (!RequestMessageProcessor.paramsRangeValidation(cmdParameter, params)) {
                return "Param wrong range:" + cmdParameter.getParameterName();
            }
            if (RequestMessageProcessor.paramsRegexValidation(cmdParameter, params)) continue;
            return "Param wrong format:" + cmdParameter.getParameterName();
        }
        return null;
    }

    private static boolean paramsRangeValidation(CmdParameter cmdParameter, Map params) {
        if (StringUtils.isNull((String)cmdParameter.getParameterValidRange())) {
            return true;
        }
        if (!cmdParameter.getParameterValidRange().matches("\\[(\\-|\\+)?\\d+(\\.\\d+)?,(\\-|\\+)?\\d+(\\.\\d+)?\\]")) {
            return true;
        }
        if (params == null || params.get(cmdParameter.getParameterName()) == null) {
            return false;
        }
        String range = cmdParameter.getParameterValidRange();
        BigDecimal start = range.startsWith("(") ? new BigDecimal(range.substring(range.indexOf("(") + 1, range.indexOf(","))) : new BigDecimal(range.substring(range.indexOf("[") + 1, range.indexOf(",")));
        BigDecimal end = range.endsWith(")") ? new BigDecimal(range.substring(range.indexOf(",") + 1, range.indexOf(")"))) : new BigDecimal(range.substring(range.indexOf(",") + 1, range.indexOf("]")));
        BigDecimal value = new BigDecimal(params.get(cmdParameter.getParameterName()).toString());
        return value.compareTo(start) >= 0 && value.compareTo(end) <= 0;
    }

    private static boolean paramsRegexValidation(CmdParameter cmdParameter, Map params) {
        if (StringUtils.isNull((String)cmdParameter.getParameterValidRegExp())) {
            return true;
        }
        if (params == null || params.get(cmdParameter.getParameterName()) == null) {
            return false;
        }
        String value = params.get(cmdParameter.getParameterName()).toString();
        return value.matches(cmdParameter.getParameterValidRegExp());
    }

    private static Response invoke(String invokeClass, String invokeMethod, Map params) throws Exception {
        Class<?> clz = classMap.get(invokeClass);
        if (clz == null) {
            clz = Class.forName(invokeClass);
            classMap.put(invokeClass, clz);
        }
        Method method = clz.getDeclaredMethod(invokeMethod, Map.class);
        BaseCmd cmd = (BaseCmd)handlerMap.get(invokeClass);
        if (cmd == null) {
            return MessageUtil.newFailResponse("", "Cmd not found");
        }
        return (Response)method.invoke((Object)cmd, params);
    }
}

