/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rpc.netty.processor;

import io.netty.channel.Channel;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.invoke.BaseInvoke;
import io.nuls.core.rpc.invoke.KernelInvoke;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.message.Message;
import io.nuls.core.rpc.model.message.MessageType;
import io.nuls.core.rpc.model.message.MessageUtil;
import io.nuls.core.rpc.model.message.Request;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.model.message.Unsubscribe;
import io.nuls.core.rpc.netty.channel.manager.ConnectManager;
import io.nuls.core.rpc.netty.processor.container.RequestContainer;
import io.nuls.core.rpc.netty.processor.container.ResponseContainer;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ResponseMessageProcessor {
    private static final Long REGISTER_API_TIME_OUT = 180000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handshake(String url) throws Exception {
        Channel channel = ConnectManager.getConnectByUrl(url);
        if (channel == null) {
            throw new Exception("Kernel not available");
        }
        Message message = MessageUtil.basicMessage(MessageType.NegotiateConnection);
        message.setMessageData(MessageUtil.defaultNegotiateConnection());
        ResponseContainer responseContainer = RequestContainer.putRequest(message.getMessageID());
        ConnectManager.sendMessage(channel, JSONUtils.obj2json((Object)message));
        try {
            boolean bl = responseContainer.getFuture().get(10000L, TimeUnit.MILLISECONDS) != null;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            RequestContainer.removeResponseContainer(message.getMessageID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handshake(Channel channel) throws Exception {
        Message message = MessageUtil.basicMessage(MessageType.NegotiateConnection);
        message.setMessageData(MessageUtil.defaultNegotiateConnection());
        ResponseContainer responseContainer = RequestContainer.putRequest(message.getMessageID());
        ConnectManager.sendMessage(channel, JSONUtils.obj2json((Object)message));
        try {
            boolean bl = responseContainer.getFuture().get(10000L, TimeUnit.MILLISECONDS) != null;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            RequestContainer.removeResponseContainer(message.getMessageID());
        }
    }

    public static void syncKernel(String kernelUrl) throws Exception {
        ResponseMessageProcessor.syncKernel(kernelUrl, new KernelInvoke());
    }

    public static void syncKernel(String kernelUrl, BaseInvoke callbackInvoke) throws Exception {
        Request request = MessageUtil.defaultRequest();
        request.getRequestMethods().put("RegisterAPI", ConnectManager.LOCAL);
        Message message = MessageUtil.basicMessage(MessageType.Request);
        message.setMessageData(request);
        Channel channel = ConnectManager.getConnectByUrl(kernelUrl);
        if (channel == null) {
            throw new Exception("Kernel not available");
        }
        ResponseContainer responseContainer = RequestContainer.putRequest(message.getMessageID());
        ConnectManager.sendMessage(channel, JSONUtils.obj2json((Object)message));
        Response response = ResponseMessageProcessor.receiveResponse(responseContainer, REGISTER_API_TIME_OUT);
        for (int tryCount = 0; !response.isSuccess() && tryCount < 3; ++tryCount) {
            Log.info((String)"\u5411\u6838\u5fc3\u6ce8\u518c\u6d88\u606f\u53d1\u9001\u5931\u8d25\u7b2c{}\u6b21", (Object[])new Object[]{tryCount + 1});
            responseContainer = RequestContainer.putRequest(message.getMessageID());
            ConnectManager.sendMessage(channel, JSONUtils.obj2json((Object)message));
            response = ResponseMessageProcessor.receiveResponse(responseContainer, REGISTER_API_TIME_OUT);
        }
        if (!response.isSuccess()) {
            throw new Exception("\u5411\u6838\u5fc3\u6ce8\u518c\u5931\u8d25\uff01");
        }
        callbackInvoke.callBack(response);
        ResponseMessageProcessor.requestAndInvoke(ModuleE.KE.abbr, "RegisterAPI", JSONUtils.json2map((String)JSONUtils.obj2json((Object)ConnectManager.LOCAL)), "0", "1", callbackInvoke);
        Log.debug((String)("Sync manager success. " + JSONUtils.obj2json(ConnectManager.ROLE_MAP)));
    }

    public static Response requestAndResponse(String role, String cmd, Map params) throws Exception {
        return ResponseMessageProcessor.requestAndResponse(role, cmd, params, 10000L);
    }

    public static Response requestAndResponse(String role, String cmd, Map params, long timeOut) throws Exception {
        Request request = MessageUtil.newRequest(cmd, params, "0", "0", "0");
        ResponseContainer responseContainer = ResponseMessageProcessor.sendRequest(role, request);
        return ResponseMessageProcessor.receiveResponse(responseContainer, timeOut);
    }

    public static String requestAndInvoke(String role, String cmd, Map params, String subscriptionPeriod, String subscriptionEventCounter, BaseInvoke baseInvoke) throws Exception {
        Request request = MessageUtil.newRequest(cmd, params, "0", subscriptionPeriod, subscriptionEventCounter);
        ResponseContainer responseContainer = ResponseMessageProcessor.sendRequest(role, request);
        ConnectManager.INVOKE_MAP.put(responseContainer.getMessageId(), baseInvoke);
        RequestContainer.removeResponseContainer(responseContainer.getMessageId());
        return responseContainer.getMessageId();
    }

    public static String requestAndInvokeWithAck(String role, String cmd, Map params, String subscriptionPeriod, String subscriptionEventCounter, BaseInvoke baseInvoke) throws Exception {
        Request request = MessageUtil.newRequest(cmd, params, "1", subscriptionPeriod, subscriptionEventCounter);
        ResponseContainer responseContainer = ResponseMessageProcessor.sendRequest(role, request);
        ConnectManager.INVOKE_MAP.put(responseContainer.getMessageId(), baseInvoke);
        return ResponseMessageProcessor.receiveResponse(responseContainer, 10000L) != null ? responseContainer.getMessageId() : null;
    }

    public static String requestAndInvoke(String role, Request request, BaseInvoke baseInvoke) throws Exception {
        if (!ConnectManager.isPureDigital(request.getSubscriptionPeriod()) && !ConnectManager.isPureDigital(request.getSubscriptionEventCounter())) {
            throw new Exception("Wrong value: [SubscriptionPeriod][SubscriptionEventCounter]");
        }
        ResponseContainer responseContainer = ResponseMessageProcessor.sendRequest(role, request);
        ConnectManager.INVOKE_MAP.put(responseContainer.getMessageId(), baseInvoke);
        if ("0".equals(request.getRequestAck())) {
            return responseContainer.getMessageId();
        }
        return ResponseMessageProcessor.receiveResponse(responseContainer, 10000L) != null ? responseContainer.getMessageId() : null;
    }

    public static String requestOnly(String role, Request request) throws Exception {
        Message message = MessageUtil.basicMessage(MessageType.RequestOnly);
        message.setMessageData(request);
        Channel channel = ConnectManager.getConnectByRole(role);
        if (!channel.isWritable()) {
            Log.info((String)"\u5f53\u524d\u8bf7\u6c42\u5806\u79ef\u8fc7\u591a,\u7b49\u5f85\u8bf7\u6c42\u5904\u7406");
            return "0";
        }
        ConnectManager.sendMessage(channel, JSONUtils.obj2json((Object)message));
        return message.getMessageID();
    }

    private static ResponseContainer sendRequest(String role, Request request) throws Exception {
        Message message = MessageUtil.basicMessage(MessageType.Request);
        message.setMessageData(request);
        Channel channel = ConnectManager.getConnectByRole(role);
        ResponseContainer responseContainer = RequestContainer.putRequest(message.getMessageID());
        ConnectManager.sendMessage(channel, JSONUtils.obj2json((Object)message));
        if (ConnectManager.isPureDigital(request.getSubscriptionPeriod()) || ConnectManager.isPureDigital(request.getSubscriptionEventCounter())) {
            ConnectManager.MSG_ID_KEY_CHANNEL_MAP.put(message.getMessageID(), channel);
        }
        return responseContainer;
    }

    public static void sendUnsubscribe(String messageId) throws Exception {
        if (messageId == null) {
            return;
        }
        Message message = MessageUtil.basicMessage(MessageType.Unsubscribe);
        Unsubscribe unsubscribe = new Unsubscribe();
        unsubscribe.setUnsubscribeMethods(new String[]{messageId});
        message.setMessageData(unsubscribe);
        Channel channel = (Channel)ConnectManager.MSG_ID_KEY_CHANNEL_MAP.get(messageId);
        if (channel != null) {
            ConnectManager.sendMessage(channel, JSONUtils.obj2json((Object)message));
            Log.debug((String)("\u53d6\u6d88\u8ba2\u9605\uff1a" + JSONUtils.obj2json((Object)message)));
            ConnectManager.INVOKE_MAP.remove(messageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response receiveResponse(ResponseContainer responseContainer, long timeOut) throws Exception {
        try {
            Response response = responseContainer.getFuture().get(timeOut, TimeUnit.MILLISECONDS);
            return response;
        }
        catch (Exception e) {
            Response response = MessageUtil.newFailResponse(responseContainer.getMessageId(), CommonCodeConstanst.REQUEST_TIME_OUT);
            return response;
        }
        finally {
            RequestContainer.removeResponseContainer(responseContainer.getMessageId());
        }
    }
}

