/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rpc.util;

import io.nuls.core.core.config.ConfigurationLoader;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.steppschuh.markdowngenerator.table.Table;
import net.steppschuh.markdowngenerator.text.Text;
import net.steppschuh.markdowngenerator.text.heading.Heading;

public class DocTool {
    static Set<String> exclusion = Set.of("io.nuls.base.protocol.cmd", "io.nuls.core.rpc.cmd.kernel", "io.nuls.core.rpc.modulebootstrap");
    static Set<Class> baseType = new HashSet<Class>();

    public static void main(String[] args) throws IOException {
        SpringLiteContext.init((String[])new String[]{"io.nuls"});
        Gen.genJSON();
        Gen.genDoc();
        System.exit(0);
    }

    static {
        baseType.add(Integer.class);
        baseType.add(Integer.TYPE);
        baseType.add(Long.class);
        baseType.add(Long.TYPE);
        baseType.add(Float.class);
        baseType.add(Float.TYPE);
        baseType.add(Double.class);
        baseType.add(Double.TYPE);
        baseType.add(Character.class);
        baseType.add(Character.TYPE);
        baseType.add(Short.class);
        baseType.add(Short.TYPE);
        baseType.add(Boolean.class);
        baseType.add(Boolean.TYPE);
        baseType.add(Byte.class);
        baseType.add(Byte.TYPE);
        baseType.add(String.class);
        baseType.add(Object[].class);
        baseType.add(BigInteger.class);
        baseType.add(BigDecimal.class);
    }

    public static class Gen {
        private static final String NA = "N/A";

        public static List<CmdDes> buildData() {
            List cmdList = SpringLiteContext.getBeanList(BaseCmd.class);
            ArrayList<CmdDes> cmdDesList = new ArrayList<CmdDes>();
            cmdList.forEach(cmd -> {
                Class<?> clazs = cmd.getClass();
                if (exclusion.contains(clazs.getPackageName())) {
                    Log.info((String)"\u8df3\u8fc7{}\u751f\u6210\u6587\u6863\uff0c\u6240\u5728\u5305{}\u5728\u6392\u9664\u8303\u56f4", (Object[])new Object[]{clazs.getSimpleName(), clazs.getPackageName()});
                    return;
                }
                Method[] methods = clazs.getMethods();
                Arrays.stream(methods).forEach(method -> {
                    Annotation annotation = method.getAnnotation(CmdAnnotation.class);
                    if (annotation == null) {
                        return;
                    }
                    CmdAnnotation cmdAnnotation = annotation;
                    CmdDes cmdDes = new CmdDes();
                    cmdDes.cmdName = cmdAnnotation.cmd();
                    cmdDes.des = cmdAnnotation.description();
                    cmdDes.scope = cmdAnnotation.scope();
                    cmdDes.version = cmdAnnotation.version();
                    cmdDes.parameters = Gen.buildParam(method);
                    annotation = method.getAnnotation(ResponseData.class);
                    if (annotation != null) {
                        ResponseData responseData = (ResponseData)annotation;
                        cmdDes.result = Gen.buildResultDes(responseData.responseType(), responseData.description(), responseData.name(), true);
                    }
                    cmdDesList.add(cmdDes);
                });
            });
            return cmdDesList;
        }

        public static void genDoc() throws IOException {
            List<CmdDes> cmdDesList = Gen.buildData();
            System.out.println(JSONUtils.obj2json(cmdDesList));
            System.out.println("\u751f\u6210\u6587\u6863\u6210\u529f\uff1a" + Gen.createMarketDownDoc(cmdDesList, "./readme.md"));
        }

        public static void genJSON() throws IOException {
            List<CmdDes> cmdDesList = Gen.buildData();
            Log.info((String)"{}", (Object[])new Object[]{cmdDesList});
            System.out.println("\u751f\u6210\u6587\u6863\u6210\u529f\uff1a" + Gen.createJSONConfig(cmdDesList, "/Users/zhoulijun/workspace/test"));
        }

        public static List<ResultDes> buildParam(Method method) {
            List<Parameter> parameters;
            Parameters annotation = method.getAnnotation(Parameters.class);
            if (annotation != null) {
                parameters = Arrays.asList(annotation.value());
            } else {
                Parameter[] parameterAry = (Parameter[])method.getAnnotationsByType(Parameter.class);
                parameters = Arrays.asList(parameterAry);
            }
            ArrayList<ResultDes> param = new ArrayList<ResultDes>();
            parameters.stream().forEach(parameter -> {
                ResultDes res = new ResultDes();
                res.type = parameter.parameterType();
                res.name = parameter.parameterName();
                res.des = parameter.parameterDes();
                res.canNull = parameter.canNull();
                if (baseType.contains(parameter.requestType().value())) {
                    param.addAll(Gen.buildResultDes(parameter.requestType(), res.des, res.name, res.canNull));
                } else {
                    param.addAll(Gen.buildResultDes(parameter.requestType(), res.des, res.name, res.canNull));
                }
            });
            return param;
        }

        public static List<ResultDes> buildResultDes(TypeDescriptor typeDescriptor, String des, String name, boolean canNull) {
            ResultDes resultDes = new ResultDes();
            if (typeDescriptor.value() == Void.class) {
                resultDes.type = "void";
                resultDes.des = des;
                resultDes.name = NA;
                return List.of(resultDes);
            }
            if (baseType.contains(typeDescriptor.value())) {
                resultDes.des = des;
                resultDes.name = name;
                resultDes.type = typeDescriptor.value().getSimpleName().toLowerCase();
                resultDes.canNull = canNull;
                return List.of(resultDes);
            }
            if (typeDescriptor.value() == Map.class) {
                return Gen.mapToResultDes(typeDescriptor);
            }
            if (List.class == typeDescriptor.value()) {
                if (baseType.contains(typeDescriptor.collectionElement())) {
                    resultDes.type = "list&lt;" + typeDescriptor.collectionElement().getSimpleName() + ">";
                    resultDes.des = des;
                    resultDes.name = name;
                    resultDes.canNull = canNull;
                    return List.of(resultDes);
                }
                if (typeDescriptor.collectionElement() == Map.class) {
                    return Gen.mapToResultDes(typeDescriptor);
                }
                return Gen.classToResultDes(typeDescriptor.collectionElement());
            }
            if (Object[].class == typeDescriptor.value()) {
                resultDes.des = des;
                resultDes.name = name;
                resultDes.type = "object[]";
                resultDes.canNull = canNull;
                return List.of(resultDes);
            }
            ApiModel annotation = typeDescriptor.value().getAnnotation(ApiModel.class);
            if (annotation == null) {
                resultDes.type = typeDescriptor.value().getSimpleName().toLowerCase();
                resultDes.name = name;
                resultDes.des = des;
                resultDes.canNull = canNull;
                return List.of(resultDes);
            }
            return Gen.classToResultDes(typeDescriptor.value());
        }

        public static List<ResultDes> mapToResultDes(TypeDescriptor typeDescriptor) {
            Key[] keys = typeDescriptor.mapKeys();
            ArrayList<ResultDes> res = new ArrayList<ResultDes>();
            Arrays.stream(keys).forEach(key -> {
                ResultDes rd = new ResultDes();
                if (baseType.contains(key.valueType())) {
                    rd.type = key.valueType().getSimpleName().toLowerCase();
                    rd.name = key.name();
                    rd.des = key.description();
                } else if (List.class == key.valueType()) {
                    rd.name = key.name();
                    rd.des = key.description();
                    if (baseType.contains(key.valueElement()) || key.valueElement() == Map.class) {
                        rd.type = "list&lt;" + key.valueElement().getSimpleName() + ">";
                    } else {
                        rd.list = Gen.classToResultDes(key.valueElement());
                        rd.type = "list&lt;object>";
                    }
                } else if (Map.class == key.valueType()) {
                    rd.type = "map";
                    rd.name = key.name();
                    rd.des = key.description();
                } else {
                    ApiModel annotation = key.valueType().getAnnotation(ApiModel.class);
                    if (annotation == null) {
                        rd.type = key.valueType().getSimpleName().toLowerCase();
                        rd.name = key.name();
                        rd.des = key.description();
                    } else {
                        rd.type = "object";
                        rd.name = key.name();
                        rd.des = key.description();
                        rd.list = Gen.classToResultDes(key.valueType());
                    }
                }
                res.add(rd);
            });
            return res;
        }

        public static List<ResultDes> classToResultDes(Class<?> clzs) {
            ApiModel annotation = clzs.getAnnotation(ApiModel.class);
            if (annotation == null) {
                throw new IllegalArgumentException("\u8fd4\u56de\u503c\u662f\u590d\u6742\u5bf9\u8c61\u65f6\u5fc5\u987b\u58f0\u660eApiModule\u6ce8\u89e3 + " + clzs.getSimpleName());
            }
            LinkedList<Field> list = new LinkedList<Field>();
            list.addAll(Arrays.asList(clzs.getDeclaredFields()));
            Class<?> clzsTemp = clzs.getSuperclass();
            while (clzsTemp.getAnnotation(ApiModel.class) != null) {
                list.addAll(0, Arrays.asList(clzsTemp.getDeclaredFields()));
                clzsTemp = clzsTemp.getSuperclass();
            }
            Field[] fileds = new Field[list.size()];
            list.toArray(fileds);
            ArrayList<ResultDes> filedList = new ArrayList<ResultDes>();
            Arrays.stream(fileds).forEach(filed -> {
                ApiModelProperty ann = filed.getAnnotation(ApiModelProperty.class);
                ApiModelProperty apiModelProperty = ann;
                if (apiModelProperty == null) {
                    Log.warn((String)"\u53d1\u73b0\u672a\u914d\u7f6eApiModelProperty\u6ce8\u89e3\u7684filed:{}", (Object[])new Object[]{clzs.getSimpleName() + "#" + filed.getName()});
                    return;
                }
                ResultDes filedDes = new ResultDes();
                filedDes.des = apiModelProperty.description();
                filedDes.name = filed.getName();
                boolean bl = filedDes.canNull = !apiModelProperty.required();
                if (apiModelProperty.type().value() != Void.class) {
                    if (baseType.contains(apiModelProperty.type().collectionElement())) {
                        filedDes.type = "list&lt;" + apiModelProperty.type().collectionElement().getSimpleName() + ">";
                    } else {
                        filedDes.list = Gen.buildResultDes(apiModelProperty.type(), filedDes.des, filedDes.name, filedDes.canNull);
                        if (apiModelProperty.type().value() == List.class) {
                            filedDes.type = "list&lt;object>";
                        } else if (apiModelProperty.type().value() == Map.class) {
                            filedDes.type = "map";
                        }
                    }
                } else if (baseType.contains(filed.getType())) {
                    filedDes.type = filed.getType().getSimpleName().toLowerCase();
                } else {
                    ApiModel filedAnn = filed.getType().getAnnotation(ApiModel.class);
                    if (filedAnn == null) {
                        Log.warn((String)"\u53d1\u73b0ApiModelProperty\u6ce8\u89e3\u7684filed\u7c7b\u578b\u4e3a\u590d\u6742\u5bf9\u8c61\uff0c\u4f46\u5bf9\u8c61\u5e76\u672a\u6ce8\u89e3ApiModel\uff0cfiled:{}", (Object[])new Object[]{clzs.getName() + "#" + filed.getName()});
                        filedDes.type = filed.getType().getSimpleName().toLowerCase();
                    } else if (clzs == filed.getType()) {
                        Log.warn((String)"\u53d1\u73b0\u5faa\u73af\u5f15\u7528\uff1a{}", (Object[])new Object[]{clzs});
                        filedDes.type = "object&lt;" + clzs.getSimpleName().toLowerCase() + ">";
                    } else {
                        filedDes.list = Gen.classToResultDes(filed.getType());
                        filedDes.type = "object";
                    }
                }
                filedList.add(filedDes);
            });
            return filedList;
        }

        public static String createJSONConfig(List<CmdDes> cmdDesList, String path) throws IOException {
            ConfigurationLoader configurationLoader = (ConfigurationLoader)SpringLiteContext.getBean(ConfigurationLoader.class);
            ConfigurationLoader.ConfigItem configItem = configurationLoader.getConfigItem("APP_NAME");
            String appName = configItem.getValue();
            File mdFile = new File(path + File.separator + appName + ".json");
            if (mdFile.exists()) {
                mdFile.delete();
            }
            mdFile.createNewFile();
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(mdFile));){
                cmdDesList.forEach(cmd -> {
                    try {
                        StringWriter stringWriter = new StringWriter();
                        try (BufferedWriter sbw = new BufferedWriter(stringWriter);){
                            Gen.writeMarkdown(cmd, sbw);
                            sbw.flush();
                            cmd.md = stringWriter.toString();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
                writer.write(JSONUtils.obj2json(cmdDesList));
            }
            return mdFile.getAbsolutePath();
        }

        public static String createMarketDownDoc(List<CmdDes> cmdDesList, String tempFile) throws IOException {
            ConfigurationLoader configurationLoader = (ConfigurationLoader)SpringLiteContext.getBean(ConfigurationLoader.class);
            String appName = configurationLoader.getConfigItem("APP_NAME").getValue();
            File file = new File(tempFile);
            if (!file.exists()) {
                throw new RuntimeException("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            File mdFile = new File(file.getParentFile().getAbsolutePath() + File.separator + "documents" + File.separator + appName + ".md");
            if (mdFile.exists()) {
                mdFile.delete();
            }
            mdFile.createNewFile();
            try (FileOutputStream outputStream = new FileOutputStream(mdFile);
                 FileInputStream inputStream = new FileInputStream(file);){
                ((InputStream)inputStream).transferTo(outputStream);
                outputStream.flush();
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(mdFile, true));){
                writer.newLine();
                cmdDesList.forEach(cmd -> Gen.writeMarkdown(cmd, writer));
            }
            return mdFile.getAbsolutePath();
        }

        private static void writeMarkdown(CmdDes cmd, BufferedWriter writer) {
            try {
                writer.write(new Heading((Object)cmd.cmdName.replaceAll("_", "\\\\_"), 1).toString());
                writer.newLine();
                writer.write(new Heading((Object)("scope:" + cmd.scope), 3).toString());
                writer.newLine();
                writer.write(new Heading((Object)("version:" + cmd.version), 3).toString());
                writer.newLine();
                writer.write(new Text((Object)cmd.des).toString());
                writer.newLine();
                Gen.buildParam(writer, cmd.parameters);
                Gen.buildResult(writer, cmd.result);
                writer.newLine();
                writer.newLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private static void buildResult(BufferedWriter writer, List<ResultDes> result) throws IOException {
            writer.newLine();
            writer.newLine();
            writer.write(new Heading((Object)"\u8fd4\u56de\u503c", 2).toString());
            if (result == null) {
                writer.newLine();
                writer.write("\u65e0\u8fd4\u56de\u503c");
                return;
            }
            Table.Builder tableBuilder = new Table.Builder().withAlignments(new Integer[]{2, 1, 2}).addRow(new Object[]{"\u5b57\u6bb5\u540d", "\u5b57\u6bb5\u7c7b\u578b", "\u53c2\u6570\u63cf\u8ff0"});
            Gen.buildResult(tableBuilder, result, 0);
            writer.newLine();
            writer.write(tableBuilder.build().toString());
        }

        private static void buildResult(Table.Builder tableBuilder, List<ResultDes> result, int depth) {
            result.forEach(r -> {
                tableBuilder.addRow(new Object[]{"&nbsp;".repeat(depth * 8) + r.name, r.type.toLowerCase(), r.des});
                if (r.list != null) {
                    Gen.buildResult(tableBuilder, r.list, depth + 1);
                }
            });
        }

        private static void buildParam(BufferedWriter writer, List<ResultDes> parameters) throws IOException {
            writer.newLine();
            writer.write(new Heading((Object)"\u53c2\u6570\u5217\u8868", 2).toString());
            if (parameters == null || parameters.isEmpty()) {
                writer.newLine();
                writer.write("\u65e0\u53c2\u6570");
                return;
            }
            Table.Builder tableBuilder = new Table.Builder().withAlignments(new Integer[]{2, 1, 2, 1}).addRow(new Object[]{"\u53c2\u6570\u540d", "\u53c2\u6570\u7c7b\u578b", "\u53c2\u6570\u63cf\u8ff0", "\u662f\u5426\u975e\u7a7a"});
            Gen.buildParam(tableBuilder, parameters, 0);
            writer.newLine();
            writer.write(tableBuilder.build().toString());
        }

        private static void buildParam(Table.Builder tableBuilder, List<ResultDes> result, int depth) {
            result.forEach(r -> {
                tableBuilder.addRow(new Object[]{"&nbsp;".repeat(depth * 8) + r.name, r.type.toLowerCase(), r.des, !r.canNull ? "\u662f" : "\u5426"});
                if (r.list != null) {
                    Gen.buildParam(tableBuilder, r.list, depth + 1);
                }
            });
        }
    }

    public static class CmdDes
    implements Serializable {
        String cmdName;
        String des;
        String scope;
        double version;
        String md;
        List<ResultDes> parameters;
        List<ResultDes> result;

        public String getMd() {
            return this.md;
        }

        public void setMd(String md) {
            this.md = md;
        }

        public String getCmdName() {
            return this.cmdName;
        }

        public void setCmdName(String cmdName) {
            this.cmdName = cmdName;
        }

        public String getDes() {
            return this.des;
        }

        public void setDes(String des) {
            this.des = des;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public double getVersion() {
            return this.version;
        }

        public void setVersion(double version) {
            this.version = version;
        }

        public List<ResultDes> getParameters() {
            return this.parameters;
        }

        public void setParameters(List<ResultDes> parameters) {
            this.parameters = parameters;
        }

        public List<ResultDes> getResult() {
            return this.result;
        }

        public void setResult(List<ResultDes> result) {
            this.result = result;
        }
    }

    public static class ResultDes
    implements Serializable {
        String name;
        String des;
        String type;
        List<ResultDes> list;
        boolean canNull;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDes() {
            return this.des;
        }

        public void setDes(String des) {
            this.des = des;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public List<ResultDes> getList() {
            return this.list;
        }

        public void setList(List<ResultDes> list) {
            this.list = list;
        }

        public boolean isCanNull() {
            return this.canNull;
        }

        public void setCanNull(boolean canNull) {
            this.canNull = canNull;
        }
    }
}

