/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rpc.util;

import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.util.Map;

public class RpcCall {
    public static Object request(String moduleCode, String cmd, Map params) throws NulsException {
        return RpcCall.request(moduleCode, cmd, params, null);
    }

    public static Object request(String moduleCode, String cmd, Map params, Long timeout) throws NulsException {
        try {
            params.put("version", "1.0");
            Response cmdResp = null == timeout ? ResponseMessageProcessor.requestAndResponse(moduleCode, cmd, params) : ResponseMessageProcessor.requestAndResponse(moduleCode, cmd, params, timeout);
            Map resData = (Map)cmdResp.getResponseData();
            if (!cmdResp.isSuccess()) {
                String errorMsg;
                Log.error((String)"response error info is {}", (Object[])new Object[]{cmdResp});
                if (null == resData) {
                    errorMsg = String.format("Remote call fail. ResponseComment: %s ", cmdResp.getResponseComment());
                } else {
                    Map map = (Map)resData.get(cmd);
                    errorMsg = String.format("Remote call fail. msg: %s - code: %s - module: %s - interface: %s \n- params: %s ", map.get("msg"), map.get("code"), moduleCode, cmd, JSONUtils.obj2PrettyJson((Object)params));
                }
                throw new Exception(errorMsg);
            }
            return resData.get(cmd);
        }
        catch (Exception e) {
            Log.debug((String)"cmd: {}", (Object[])new Object[]{cmd});
            throw new NulsException((Throwable)e);
        }
    }
}

