/*
 * Decompiled with CFR 0.152.
 */
package io.opensw.scheduler.core.domain.lock;

import io.opensw.scheduler.core.domain.lock.LockRepository;
import io.opensw.scheduler.core.exceptions.DatabaseException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class LockRepositoryImpl
implements LockRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LockRepositoryImpl.class);
    private final DataSource dataSource;
    protected static final String LOCK_SELECT_QUERY = "SELECT task_key, task_method, lock_until, lock_at, lock_by FROM snap_lock WHERE task_key = ? AND task_method = ? FOR UPDATE";
    protected static final String LOCK_INSERT_QUERY = "INSERT INTO snap_lock (task_key, task_method, lock_until, lock_at, lock_by) VALUES (?, ?, ?, ?, ?);";

    @Autowired
    public LockRepositoryImpl(@Qualifier(value="snapDataSource") DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean lockTask(String key, String method, long time, String server) throws DatabaseException {
        if (this.dataSource == null) {
            throw new DatabaseException();
        }
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(LOCK_SELECT_QUERY, 1003, 1008);){
            connection.setAutoCommit(true);
            preparedStatement.setString(1, key);
            preparedStatement.setString(2, method);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) return this.insertLock(key, method, time, server);
            if (resultSet.getTimestamp(3).toInstant().isAfter(Instant.now())) {
                boolean bl = false;
                return bl;
            }
            resultSet.updateTimestamp(3, Timestamp.from(Instant.now().plus(time, ChronoUnit.SECONDS)));
            resultSet.updateTimestamp(4, Timestamp.from(Instant.now()));
            resultSet.updateString(5, server);
            resultSet.updateRow();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("(UPDATE) Can not acquire lock for key {} and method {}. Message error: {}", new Object[]{key, method, e.getMessage()});
        }
        return this.insertLock(key, method, time, server);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean insertLock(String key, String method, long time, String server) {
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement preparedStatement = connection.prepareStatement(LOCK_INSERT_QUERY);
                try {
                    connection.setAutoCommit(true);
                    preparedStatement.setString(1, key);
                    preparedStatement.setString(2, method);
                    preparedStatement.setTimestamp(3, Timestamp.from(Instant.now().plus(time, ChronoUnit.SECONDS)));
                    preparedStatement.setTimestamp(4, Timestamp.from(Instant.now()));
                    preparedStatement.setString(5, server);
                    boolean bl2 = bl = preparedStatement.executeUpdate() == 1;
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
        catch (Exception e) {
            log.error("(INSERT) Can not acquire lock for key {} and method {}. Message error: {}", new Object[]{key, method, e.getMessage()});
            return false;
        }
    }
}

