/*
 * Decompiled with CFR 0.152.
 */
package io.opensw.scheduler.core.events;

import io.opensw.scheduler.SnapSchedulerProperties;
import io.opensw.scheduler.core.domain.audit.TaskAuditRepository;
import io.opensw.scheduler.core.domain.scheduler.SchedulerRepository;
import io.opensw.scheduler.core.events.obj.TaskRunEvent;
import io.opensw.scheduler.core.scheduler.SnapTaskHandler;
import io.opensw.scheduler.core.scheduler.task.RecurringTask;
import io.opensw.scheduler.core.scheduler.task.Task;
import io.opensw.scheduler.core.scheduler.task.TaskType;
import io.opensw.scheduler.core.utils.ServerUtils;
import java.time.Duration;
import java.time.Instant;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SnapEventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnapEventListener.class);
    private final TaskAuditRepository taskAuditRepository;
    private final SchedulerRepository schedulerRepository;
    private final SnapTaskHandler snapTaskHandler;
    private final SnapSchedulerProperties properties;

    @Async
    @EventListener(classes={TaskRunEvent.class})
    public void onTaskRunEventFired(TaskRunEvent event) {
        log.debug("Listener to TaskRunEvent {}", (Object)event);
        Task task = event.getTask();
        try {
            this.taskAuditRepository.auditTask(task.getKey(), task.getClazz().getName(), event.getServer(), event.getStart(), event.getEnd(), event.getException());
        }
        catch (Exception e) {
            log.error("Error in save running task event with key {}, method {} and server {}. Error: {}", new Object[]{task.getKey(), task.getClazz().getName(), event.getServer(), e.getMessage()});
        }
        try {
            if (TaskType.RECURRING.equals((Object)task.getType()) && task instanceof RecurringTask) {
                RecurringTask recurringTask = (RecurringTask)task;
                boolean picked = false;
                String pickedBy = null;
                recurringTask.runAt(recurringTask.getRunAt().plus(recurringTask.getRecurrence()));
                long diff = Duration.between(Instant.now(), recurringTask.getRunAt()).toMillis();
                if (diff < this.properties.dbPollingInterval() * 2L) {
                    this.snapTaskHandler.handleTask(recurringTask);
                    picked = true;
                    pickedBy = ServerUtils.loadServerName();
                }
                this.schedulerRepository.updateRecurringTask(recurringTask, picked, pickedBy);
            } else {
                this.schedulerRepository.updateTask(task.getKey(), event.getEnd());
            }
        }
        catch (Exception e) {
            log.error("(ServiceEventListener.onTaskRunEventFired) Error on update runned task with key {}.", (Object)task.getKey());
        }
    }

    @Generated
    public SnapEventListener(TaskAuditRepository taskAuditRepository, SchedulerRepository schedulerRepository, SnapTaskHandler snapTaskHandler, SnapSchedulerProperties properties) {
        this.taskAuditRepository = taskAuditRepository;
        this.schedulerRepository = schedulerRepository;
        this.snapTaskHandler = snapTaskHandler;
        this.properties = properties;
    }
}

