/*
 * Decompiled with CFR 0.152.
 */
package io.opensw.scheduler.core.domain.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.opensw.scheduler.core.domain.audit.TaskAuditRepository;
import io.opensw.scheduler.core.exceptions.DatabaseException;
import io.opensw.scheduler.core.utils.DbUtils;
import io.opensw.scheduler.core.utils.SnapExceptionUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TaskAuditRepositoryImpl
implements TaskAuditRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskAuditRepositoryImpl.class);
    private final DataSource dataSource;
    private final ObjectMapper mapper;
    private final String dbPlatform;
    protected static final String INSERT_QUERY = "INSERT INTO snap_task_audit(task_key, task_method, run_on, start_run, end_run, run_time_seconds, task_error) VALUES (?, ?, ?, ?, ?, ?, ?);";
    protected static final String POSTGRE_INSERT_QUERY = "INSERT INTO snap_task_audit(task_key, task_method, run_on, start_run, end_run, run_time_seconds, task_error) VALUES (?, ?, ?, ?, ?, ?, ?::jsonb);";

    @Autowired
    public TaskAuditRepositoryImpl(@Qualifier(value="snapDataSource") DataSource dataSource, ObjectMapper mapper) {
        this.dataSource = dataSource;
        this.mapper = mapper;
        this.dbPlatform = DbUtils.databaseType(dataSource);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean auditTask(String key, String method, String server, Instant start, Instant end, Exception exception) throws DatabaseException {
        if (this.dataSource == null) {
            throw new DatabaseException();
        }
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block15: {
                PreparedStatement preparedStatement = connection.prepareStatement(this.insertQuery(this.dbPlatform));
                try {
                    connection.setAutoCommit(true);
                    preparedStatement.setString(1, key);
                    preparedStatement.setString(2, method);
                    preparedStatement.setString(3, server);
                    preparedStatement.setTimestamp(4, Timestamp.from(start));
                    preparedStatement.setTimestamp(5, Timestamp.from(end));
                    preparedStatement.setLong(6, Duration.between(start, end).toMillis() / 1000L);
                    String excptionStr = exception != null ? this.mapper.writeValueAsString(SnapExceptionUtils.toMap(exception)) : null;
                    preparedStatement.setString(7, excptionStr);
                    boolean bl2 = bl = preparedStatement.executeUpdate() > 0;
                    if (preparedStatement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
        catch (Exception e) {
            log.error("(INSERT) Can not insert task audit with key {}, method {} and server {}. Message error: {}", new Object[]{key, method, server, e.getMessage()});
            return false;
        }
    }

    private String insertQuery(String platform) {
        switch (platform) {
            case "PostgreSQL": {
                return POSTGRE_INSERT_QUERY;
            }
        }
        return INSERT_QUERY;
    }
}

