/*
 * Decompiled with CFR 0.152.
 */
package io.opensw.scheduler.core.scheduler;

import io.opensw.scheduler.SnapSchedulerProperties;
import io.opensw.scheduler.core.domain.scheduler.SchedulerRepository;
import io.opensw.scheduler.core.exceptions.UnexpectedException;
import io.opensw.scheduler.core.scheduler.TimerTaskRunner;
import io.opensw.scheduler.core.scheduler.task.Task;
import io.opensw.scheduler.core.utils.ServerUtils;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class SnapTaskHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnapTaskHandler.class);
    private final SchedulerRepository schedulerRepository;
    private final SnapSchedulerProperties properties;
    private final ApplicationContext context;
    private final ApplicationEventPublisher applicationEventPublisher;

    public void handleDbTasks() {
        log.debug("SnapTaskHandler.handleDbTasks start handle tasks");
        try {
            List<Task> tasks = this.schedulerRepository.loadTasksToRun(ServerUtils.loadServerName(), this.properties.dbPollingInterval());
            for (Task task : tasks) {
                this.handleTask(task);
            }
        }
        catch (Exception e) {
            log.error("(SnapTaskHandler.handleDbTasks) error occure when trie to load tasks to run: Error: {}", (Object)e.getMessage());
        }
    }

    public void handleTask(Task task) throws UnexpectedException {
        try {
            Timer timer = new Timer();
            if (task.getRunAt().isBefore(Instant.now())) {
                task.runAt(Instant.now().plusSeconds(30L));
            }
            timer.schedule((TimerTask)new TimerTaskRunner(task, this.context, this.applicationEventPublisher), Date.from(task.getRunAt()));
        }
        catch (Exception e) {
            log.error("(SnapTaskHandler.handleTask) Error on handle task. Error: ", (Object)e.getMessage());
            throw new UnexpectedException(e.getMessage());
        }
    }

    @Generated
    public SnapTaskHandler(SchedulerRepository schedulerRepository, SnapSchedulerProperties properties, ApplicationContext context, ApplicationEventPublisher applicationEventPublisher) {
        this.schedulerRepository = schedulerRepository;
        this.properties = properties;
        this.context = context;
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

