/*
 * Decompiled with CFR 0.152.
 */
package io.opensw.scheduler.core.annotations;

import io.opensw.scheduler.core.annotations.SnapLock;
import io.opensw.scheduler.core.domain.lock.LockRepository;
import io.opensw.scheduler.core.events.obj.TaskRunEvent;
import io.opensw.scheduler.core.scheduler.task.LockedTask;
import io.opensw.scheduler.core.utils.ServerUtils;
import java.time.Instant;
import java.util.Optional;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SnapLockAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnapLockAspect.class);
    private final LockRepository lockRepository;
    private final ApplicationEventPublisher applicationEventPublisher;
    private static final String SERVER_NAME = ServerUtils.loadServerName();

    @Pointcut(value="execution(@io.opensw.scheduler.core.annotations.SnapLock * *(..))")
    public void snapLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="snapLock() && @annotation(snapLock)")
    public Object snapLockResolver(ProceedingJoinPoint point, SnapLock snapLock) throws Throwable {
        log.trace("Intercepting invocation of method {}", (Object)point.getSignature().getName());
        String method = point.getSignature().getDeclaringTypeName().concat(".").concat(point.getSignature().getName());
        boolean lock = this.lockRepository.lockTask(snapLock.key(), method, snapLock.time(), SERVER_NAME);
        if (lock) {
            Exception exception = null;
            Instant start = Instant.now();
            try {
                Object object = point.proceed();
                return object;
            }
            catch (Exception e) {
                exception = e;
                log.error("(SnapLockAspect.snapLockResolver) Error occured on running task {}.", (Object)snapLock.key());
            }
            finally {
                LockedTask task = LockedTask.create(Class.forName(point.getSignature().getDeclaringTypeName())).key(snapLock.key());
                this.applicationEventPublisher.publishEvent((Object)TaskRunEvent.create(task, SERVER_NAME, start, Instant.now(), exception));
            }
        }
        return Optional.empty();
    }

    @Generated
    public SnapLockAspect(LockRepository lockRepository, ApplicationEventPublisher applicationEventPublisher) {
        this.lockRepository = lockRepository;
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

