/*
 * Decompiled with CFR 0.152.
 */
package io.opensw.scheduler.core.domain.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.opensw.scheduler.core.domain.audit.TaskAuditRepository;
import io.opensw.scheduler.core.exceptions.DatabaseException;
import io.opensw.scheduler.core.utils.DbUtils;
import io.opensw.scheduler.core.utils.SnapExceptionUtils;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskAuditRepositoryImpl
implements TaskAuditRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskAuditRepositoryImpl.class);
    private final DataSource dataSource;
    private final String dbPlatform;
    private final ObjectMapper mapper;
    protected static final String MYSQL_INSERT_QUERY = "INSERT INTO snap_task_audit(`key`, `method`, run_on, start_run, end_run, run_time_seconds, task_error) VALUES (?, ?, ?, ?, ?, ?, ?);";
    protected static final String POSTGRE_INSERT_QUERY = "INSERT INTO snap_task_audit(key, method, run_on, start_run, end_run, run_time_seconds, task_error) VALUES (?, ?, ?, ?, ?, ?, ?::jsonb);";
    protected static final String MSSQL_INSERT_QUERY = "INSERT INTO snap_task_audit([key], method, run_on, start_run, end_run, run_time_seconds, task_error) VALUES (?, ?, ?, ?, ?, ?, ?);";
    protected static final String H2_INSERT_QUERY = "INSERT INTO snap_task_audit(key, method, run_on, start_run, end_run, run_time_seconds, task_error) VALUES (?, ?, ?, ?, ?, ?, ?);";

    public TaskAuditRepositoryImpl(DataSource dataSource, ObjectMapper mapper) {
        this.dataSource = dataSource;
        this.mapper = mapper;
        this.dbPlatform = DbUtils.databaseType(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean auditTask(String key, String method, String server, Instant start, Instant end, Exception exception) throws DatabaseException {
        block20: {
            if (this.dataSource == null) {
                throw new DatabaseException();
            }
            Statement preparedStatement = null;
            try {
                boolean bl;
                block19: {
                    Connection connection = this.dataSource.getConnection();
                    try {
                        connection.setAutoCommit(true);
                        preparedStatement = connection.prepareStatement(this.insertQuery(this.dbPlatform));
                        preparedStatement.setString(1, key);
                        preparedStatement.setString(2, method);
                        preparedStatement.setString(3, server);
                        preparedStatement.setTimestamp(4, Timestamp.from(start));
                        preparedStatement.setTimestamp(5, Timestamp.from(end));
                        preparedStatement.setLong(6, Duration.between(start, end).toMillis() / 1000L);
                        String excptionStr = exception != null ? this.mapper.writeValueAsString(SnapExceptionUtils.toMap(exception)) : null;
                        preparedStatement.setString(7, excptionStr);
                        boolean bl2 = bl = preparedStatement.executeUpdate() > 0;
                        if (connection == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            log.error("(INSERT) Can not insert task audit with key {}, method {} and server {}. Message error: {}", new Object[]{key, method, server, e.getMessage()});
                            break block20;
                        }
                    }
                    connection.close();
                }
                return bl;
            }
            finally {
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception e) {
                        log.warn("Error on trie to close statement, message: {}", (Object)e.getMessage());
                    }
                }
            }
        }
        return false;
    }

    private String insertQuery(String platform) {
        switch (platform) {
            case "MySQL": {
                return MYSQL_INSERT_QUERY;
            }
            case "MariaDB": {
                return MYSQL_INSERT_QUERY;
            }
            case "MsSQLServer": {
                return MSSQL_INSERT_QUERY;
            }
            case "H2": {
                return H2_INSERT_QUERY;
            }
        }
        return POSTGRE_INSERT_QUERY;
    }
}

