/*
 * Decompiled with CFR 0.152.
 */
package io.opensw.scheduler.core.domain.lock;

import io.opensw.scheduler.core.domain.lock.LockRepository;
import io.opensw.scheduler.core.exceptions.DatabaseException;
import io.opensw.scheduler.core.utils.DbUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LockRepositoryImpl
implements LockRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LockRepositoryImpl.class);
    private final DataSource dataSource;
    private final String dbPlatform;
    protected static final String MYSQL_LOCK_SELECT_QUERY = "SELECT `key`, `method`, lock_until, lock_at, lock_by FROM snap_lock WHERE `key` = ? AND `method` = ? FOR UPDATE";
    protected static final String POSTGRE_LOCK_SELECT_QUERY = "SELECT key, method, lock_until, lock_at, lock_by FROM snap_lock WHERE key = ? AND method = ? FOR UPDATE";
    protected static final String MSSQL_LOCK_SELECT_QUERY = "SELECT [key], method, lock_until, lock_at, lock_by FROM snap_lock WHERE [key] = ? AND method = ? FOR UPDATE";
    protected static final String H2_LOCK_SELECT_QUERY = "SELECT key, method, lock_until, lock_at, lock_by FROM snap_lock WHERE key = ? AND method = ? FOR UPDATE";
    protected static final String MYSQL_LOCK_INSERT_QUERY = "INSERT INTO snap_lock (`key`, `method`, lock_until, lock_at, lock_by) VALUES (?, ?, ?, ?, ?);";
    protected static final String POSTGRE_LOCK_INSERT_QUERY = "INSERT INTO snap_lock (key, method, lock_until, lock_at, lock_by) VALUES (?, ?, ?, ?, ?);";
    protected static final String MSSQL_LOCK_INSERT_QUERY = "INSERT INTO snap_lock ([key], method, lock_until, lock_at, lock_by) VALUES (?, ?, ?, ?, ?);";
    protected static final String H2_LOCK_INSERT_QUERY = "INSERT INTO snap_lock (key, method, lock_until, lock_at, lock_by) VALUES (?, ?, ?, ?, ?);";

    public LockRepositoryImpl(DataSource dataSource) {
        this.dataSource = dataSource;
        this.dbPlatform = DbUtils.databaseType(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockTask(String key, String method, long time, String server) throws DatabaseException {
        if (this.dataSource == null) {
            throw new DatabaseException();
        }
        Statement preparedStatement = null;
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(true);
            preparedStatement = connection.prepareStatement(this.selectForUpdateQuery(this.dbPlatform), 1003, 1008);
            preparedStatement.setString(1, key);
            preparedStatement.setString(2, method);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                if (resultSet.getTimestamp(3).toInstant().isAfter(Instant.now())) {
                    boolean bl = false;
                    return bl;
                }
                resultSet.updateTimestamp(3, Timestamp.from(Instant.now().plus(time, ChronoUnit.SECONDS)));
                resultSet.updateTimestamp(4, Timestamp.from(Instant.now()));
                resultSet.updateString(5, server);
                resultSet.updateRow();
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("(UPDATE) Can not acquire lock for key {} and method {}. Message error: {}", new Object[]{key, method, e.getMessage()});
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception e) {
                    log.warn("Error on trie to close statement, message: {}", (Object)e.getMessage());
                }
            }
        }
        return this.insertLock(key, method, time, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertLock(String key, String method, long time, String server) {
        block19: {
            Statement preparedStatement = null;
            try {
                boolean bl;
                block18: {
                    Connection connection = this.dataSource.getConnection();
                    try {
                        connection.setAutoCommit(true);
                        preparedStatement = connection.prepareStatement(this.insertQuery(this.dbPlatform));
                        preparedStatement.setString(1, key);
                        preparedStatement.setString(2, method);
                        preparedStatement.setTimestamp(3, Timestamp.from(Instant.now().plus(time, ChronoUnit.SECONDS)));
                        preparedStatement.setTimestamp(4, Timestamp.from(Instant.now()));
                        preparedStatement.setString(5, server);
                        boolean bl2 = bl = preparedStatement.executeUpdate() == 1;
                        if (connection == null) break block18;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            log.error("(INSERT) Can not acquire lock for key {} and method {}. Message error: {}", new Object[]{key, method, e.getMessage()});
                            break block19;
                        }
                    }
                    connection.close();
                }
                return bl;
            }
            finally {
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception e) {
                        log.warn("Error on trie to close statement, message: {}", (Object)e.getMessage());
                    }
                }
            }
        }
        return false;
    }

    private String selectForUpdateQuery(String platform) {
        switch (platform) {
            case "MySQL": {
                return MYSQL_LOCK_SELECT_QUERY;
            }
            case "MariaDB": {
                return MYSQL_LOCK_SELECT_QUERY;
            }
            case "MsSQLServer": {
                return MSSQL_LOCK_SELECT_QUERY;
            }
            case "H2": {
                return "SELECT key, method, lock_until, lock_at, lock_by FROM snap_lock WHERE key = ? AND method = ? FOR UPDATE";
            }
        }
        return "SELECT key, method, lock_until, lock_at, lock_by FROM snap_lock WHERE key = ? AND method = ? FOR UPDATE";
    }

    private String insertQuery(String platform) {
        switch (platform) {
            case "MySQL": {
                return MYSQL_LOCK_INSERT_QUERY;
            }
            case "MariaDB": {
                return MYSQL_LOCK_INSERT_QUERY;
            }
            case "MsSQLServer": {
                return MSSQL_LOCK_INSERT_QUERY;
            }
            case "H2": {
                return "INSERT INTO snap_lock (key, method, lock_until, lock_at, lock_by) VALUES (?, ?, ?, ?, ?);";
            }
        }
        return "INSERT INTO snap_lock (key, method, lock_until, lock_at, lock_by) VALUES (?, ?, ?, ?, ?);";
    }
}

