/*
 * Decompiled with CFR 0.152.
 */
package io.opensw.scheduler.core.domain.scheduler;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.opensw.scheduler.core.domain.scheduler.SchedulerRepository;
import io.opensw.scheduler.core.exceptions.DatabaseException;
import io.opensw.scheduler.core.scheduler.task.OneTimeTask;
import io.opensw.scheduler.core.scheduler.task.RecurringTask;
import io.opensw.scheduler.core.scheduler.task.Task;
import io.opensw.scheduler.core.scheduler.task.TaskData;
import io.opensw.scheduler.core.scheduler.task.TaskType;
import io.opensw.scheduler.core.utils.DbUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SchedulerRepositoryImpl
implements SchedulerRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerRepositoryImpl.class);
    private final DataSource dataSource;
    private final ObjectMapper mapper;
    private final String dbPlatform;
    protected static final String MYSQL_INSERT_QUERY = "INSERT INTO snap_scheduler(name, `key`, type, task_class, task_data, task_data_class, run_at, recurrence, picked, picked_by) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
    protected static final String POSTGRE_INSERT_QUERY = "INSERT INTO snap_scheduler(name, key, type, task_class, task_data, task_data_class, run_at, recurrence, picked, picked_by) VALUES (?, ?, ?, ?, ?::jsonb, ?, ?, ?, ?, ?);";
    protected static final String MSSQL_INSERT_QUERY = "INSERT INTO snap_scheduler(name, [key], type, task_class, task_data, task_data_class, run_at, recurrence, picked, picked_by) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
    protected static final String H2_INSERT_QUERY = "INSERT INTO snap_scheduler(name, key, type, task_class, task_data, task_data_class, run_at, recurrence, picked, picked_by) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
    protected static final String MYSQL_SELECT_QUERY = "SELECT name, `key`, type, task_class, task_data, task_data_class, run_at, recurrence, picked, picked_by FROM snap_scheduler where picked = false AND run_at < ? order by run_at asc FOR UPDATE;";
    protected static final String POSTGRE_SELECT_QUERY = "SELECT name, key, type, task_class, task_data, task_data_class, run_at, recurrence, picked, picked_by FROM snap_scheduler where picked = false AND run_at < ? order by run_at asc FOR UPDATE;";
    protected static final String MSSQL_SELECT_QUERY = "SELECT name, [key], type, task_class, task_data, task_data_class, run_at, recurrence, picked, picked_by FROM snap_scheduler where picked = 0 AND run_at < ? order by run_at asc FOR UPDATE;";
    protected static final String H2_SELECT_QUERY = "SELECT name, key, type, task_class, task_data, task_data_class, run_at, recurrence, picked, picked_by FROM snap_scheduler where picked = 0 AND run_at < ? order by run_at asc FOR UPDATE;";
    protected static final String MYSQL_UPDATE_QUERY = "UPDATE snap_scheduler SET end_run = ? WHERE `key` = ?;";
    protected static final String POSTGRE_UPDATE_QUERY = "UPDATE snap_scheduler SET end_run = ? WHERE key = ?;";
    protected static final String MSSQL_UPDATE_QUERY = "UPDATE snap_scheduler SET end_run = ? WHERE [key] = ?;";
    protected static final String H2_UPDATE_QUERY = "UPDATE snap_scheduler SET end_run = ? WHERE key = ?;";
    protected static final String MYSQL_UPDATE_RECURRING_QUERY = "UPDATE snap_scheduler SET run_at = ?, picked = ?, picked_by = ?, end_run = null WHERE `key` = ?;";
    protected static final String POSTGRE_UPDATE_RECURRING_QUERY = "UPDATE snap_scheduler SET run_at = ?, picked = ?, picked_by = ?, end_run = null WHERE key = ?;";
    protected static final String MSSQL_UPDATE_RECURRING_QUERY = "UPDATE snap_scheduler SET run_at = ?, picked = ?, picked_by = ?, end_run = null WHERE [key] = ?;";
    protected static final String H2_UPDATE_RECURRING_QUERY = "UPDATE snap_scheduler SET run_at = ?, picked = ?, picked_by = ?, end_run = null WHERE key = ?;";
    protected static final String POSTGRE_UPDATE_NOT_RUN_QUERY = "UPDATE snap_scheduler SET  picked_by = null, picked = false WHERE picked = true AND end_run is null AND picked_by = ?;";
    protected static final String MYSQL_UPDATE_NOT_RUN_QUERY = "UPDATE snap_scheduler SET picked_by = null, picked = false WHERE `key` in (select `key` from snap_scheduler where picked = true AND end_run is null AND picked_by = ?);";
    protected static final String MSSQL_UPDATE_NOT_RUN_QUERY = "UPDATE snap_scheduler SET picked_by = null, picked = 0 WHERE picked = 1 AND end_run is null AND picked_by = ?;";
    protected static final String H2_UPDATE_NOT_RUN_QUERY = "UPDATE snap_scheduler SET picked_by = null, picked = 0 WHERE picked = 1 AND end_run is null AND picked_by = ?;";

    public SchedulerRepositoryImpl(DataSource dataSource, ObjectMapper mapper) {
        this.dataSource = dataSource;
        this.mapper = mapper;
        this.dbPlatform = DbUtils.databaseType(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Task> loadTasksToRun(String server, long pollingInterval) throws DatabaseException {
        if (this.dataSource == null) {
            throw new DatabaseException();
        }
        ArrayList<Task> tasks = new ArrayList<Task>();
        Statement preparedStatement = null;
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(true);
            preparedStatement = connection.prepareStatement(this.selectTasksForUpdateQuery(this.dbPlatform), 1003, 1008);
            preparedStatement.setTimestamp(1, Timestamp.from(Instant.now().plus(pollingInterval * 2L, ChronoUnit.MILLIS)));
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                TaskType type = TaskType.valueOf(resultSet.getString(3));
                Task task = null;
                task = TaskType.RECURRING.equals((Object)type) ? this.buildRecurringTaskFromResultSet(resultSet) : this.buildOneTimeTaskFromResultSet(resultSet);
                try {
                    if (task == null) continue;
                    tasks.add(task);
                    resultSet.updateBoolean(9, true);
                    resultSet.updateString(10, server);
                    resultSet.updateRow();
                }
                catch (Exception e) {
                    log.error("Can not update task and remove from list of tasks.");
                    tasks.remove(task);
                }
            }
        }
        catch (Exception e) {
            log.error("(SchedulerRepositoryImpl.selectTasks) unexpected error occurred: {}", (Object)e.getMessage());
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception e) {
                    log.warn("Error on trie to close statement, message: {}", (Object)e.getMessage());
                }
            }
        }
        return tasks;
    }

    @Override
    public boolean insertTask(Task task) throws DatabaseException {
        return this.insertTask(task, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insertTask(Task task, boolean picked, String server) throws DatabaseException {
        block22: {
            if (this.dataSource == null) {
                throw new DatabaseException();
            }
            Statement preparedStatement = null;
            try {
                boolean bl;
                block21: {
                    Connection connection = this.dataSource.getConnection();
                    try {
                        connection.setAutoCommit(true);
                        preparedStatement = connection.prepareStatement(this.insertQuery(this.dbPlatform));
                        preparedStatement.setString(1, task.getName());
                        preparedStatement.setString(2, task.getKey());
                        preparedStatement.setString(3, task.getType().toString());
                        preparedStatement.setString(4, task.getClazz().getName());
                        preparedStatement.setObject(5, task.getData() != null ? this.mapper.writeValueAsString((Object)task.getData()) : null);
                        preparedStatement.setString(6, task.getData() != null ? task.getData().getClass().getName() : null);
                        preparedStatement.setTimestamp(7, Timestamp.from(task.getRunAt()));
                        if (task instanceof RecurringTask) {
                            Duration duration = ((RecurringTask)task).getRecurrence();
                            preparedStatement.setObject(8, duration.toString());
                        } else {
                            preparedStatement.setObject(8, null);
                        }
                        preparedStatement.setBoolean(9, picked);
                        preparedStatement.setString(10, server);
                        boolean bl2 = bl = preparedStatement.executeUpdate() == 1;
                        if (connection == null) break block21;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            log.error("(SchedulerRepositoryImpl.insertTask) Can not insert task {}. Message error: {}", (Object)task.toString(), (Object)e.getMessage());
                            break block22;
                        }
                    }
                    connection.close();
                }
                return bl;
            }
            finally {
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception e) {
                        log.warn("Error on trie to close statement, message: {}", (Object)e.getMessage());
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateTask(String key, Instant end) throws DatabaseException {
        block20: {
            if (this.dataSource == null) {
                throw new DatabaseException();
            }
            Statement preparedStatement = null;
            try {
                boolean bl;
                block19: {
                    Connection connection = this.dataSource.getConnection();
                    try {
                        connection.setAutoCommit(true);
                        preparedStatement = connection.prepareStatement(this.updateQuery(this.dbPlatform));
                        preparedStatement.setTimestamp(1, Timestamp.from(end));
                        preparedStatement.setString(2, key);
                        boolean bl2 = bl = preparedStatement.executeUpdate() == 1;
                        if (connection == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            log.error("(SchedulerRepositoryImpl.updateTask) Can not update task with key {}. Message error: {}", (Object)key, (Object)e.getMessage());
                            break block20;
                        }
                    }
                    connection.close();
                }
                return bl;
            }
            finally {
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception e) {
                        log.warn("Error on trie to close statement, message: {}", (Object)e.getMessage());
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateRecurringTask(RecurringTask task, boolean picked, String pickedBy) throws DatabaseException {
        block20: {
            if (this.dataSource == null) {
                throw new DatabaseException();
            }
            Statement preparedStatement = null;
            try {
                boolean bl;
                block19: {
                    Connection connection = this.dataSource.getConnection();
                    try {
                        connection.setAutoCommit(true);
                        preparedStatement = connection.prepareStatement(this.updateRecurringTaskQuery(this.dbPlatform));
                        preparedStatement.setTimestamp(1, Timestamp.from(task.getRunAt()));
                        preparedStatement.setBoolean(2, picked);
                        preparedStatement.setString(3, pickedBy);
                        preparedStatement.setString(4, task.getKey());
                        boolean bl2 = bl = preparedStatement.executeUpdate() == 1;
                        if (connection == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            log.error("(SchedulerRepositoryImpl.updateRecurringTask) Can not update task with key {}. Message error: {}", (Object)task.getKey(), (Object)e.getMessage());
                            break block20;
                        }
                    }
                    connection.close();
                }
                return bl;
            }
            finally {
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception e) {
                        log.warn("Error on trie to close statement, message: {}", (Object)e.getMessage());
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateNotRunnedTask(String server) throws DatabaseException {
        block20: {
            if (this.dataSource == null) {
                throw new DatabaseException();
            }
            Statement preparedStatement = null;
            try {
                boolean bl;
                block19: {
                    Connection connection = this.dataSource.getConnection();
                    try {
                        connection.setAutoCommit(true);
                        preparedStatement = connection.prepareStatement(this.updateNotRunnedQuery(this.dbPlatform));
                        preparedStatement.setString(1, server);
                        boolean bl2 = bl = preparedStatement.executeUpdate() == 1;
                        if (connection == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            log.error("(SchedulerRepositoryImpl.updateNotRunnedTask) Can not update tasks not runned in server {}. Message error: {}", (Object)server, (Object)e.getMessage());
                            break block20;
                        }
                    }
                    connection.close();
                }
                return bl;
            }
            finally {
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception e) {
                        log.warn("Error on trie to close statement, message: {}", (Object)e.getMessage());
                    }
                }
            }
        }
        return false;
    }

    private OneTimeTask buildOneTimeTaskFromResultSet(ResultSet resultSet) {
        try {
            OneTimeTask task = OneTimeTask.create(Class.forName(resultSet.getString("task_class"))).name(resultSet.getString("name")).key(resultSet.getString("key")).runAt(resultSet.getTimestamp("run_at").toInstant());
            String data = resultSet.getString("task_data");
            String dataClass = resultSet.getString("task_data_class");
            if (data != null && !data.isEmpty() && dataClass != null && !dataClass.isEmpty()) {
                Class<?> dataClazz = Class.forName(dataClass);
                task.data((TaskData)this.mapper.readValue(data, dataClazz)).dataClazz((Class)dataClazz);
            }
            return task;
        }
        catch (Exception e) {
            log.error("(SchedulerRepositoryImpl.buildOneTimeTaskFromResultSet) Can not serialize one time task from database. Error: {}", (Object)e.getMessage());
            return null;
        }
    }

    private RecurringTask buildRecurringTaskFromResultSet(ResultSet resultSet) {
        try {
            RecurringTask task = RecurringTask.create(Class.forName(resultSet.getString("task_class"))).name(resultSet.getString("name")).key(resultSet.getString("key")).runAt(resultSet.getTimestamp("run_at").toInstant()).recurrence(Duration.parse(resultSet.getString("recurrence")));
            String data = resultSet.getString("task_data");
            String dataClass = resultSet.getString("task_data_class");
            if (data != null && !data.isEmpty() && dataClass != null && !dataClass.isEmpty()) {
                Class<?> dataClazz = Class.forName(dataClass);
                task.data((TaskData)this.mapper.readValue(data, dataClazz)).dataClazz((Class)dataClazz);
            }
            return task;
        }
        catch (Exception e) {
            log.error("(SchedulerRepositoryImpl.buildRecurringTaskFromResultSet) Can not serialize one time task from database. Error: {}", (Object)e.getMessage());
            return null;
        }
    }

    private String updateRecurringTaskQuery(String platform) {
        switch (platform) {
            case "MySQL": {
                return MYSQL_UPDATE_RECURRING_QUERY;
            }
            case "MariaDB": {
                return MYSQL_UPDATE_RECURRING_QUERY;
            }
            case "MsSQLServer": {
                return MSSQL_UPDATE_RECURRING_QUERY;
            }
            case "H2": {
                return "UPDATE snap_scheduler SET run_at = ?, picked = ?, picked_by = ?, end_run = null WHERE key = ?;";
            }
        }
        return "UPDATE snap_scheduler SET run_at = ?, picked = ?, picked_by = ?, end_run = null WHERE key = ?;";
    }

    private String updateNotRunnedQuery(String platform) {
        switch (platform) {
            case "MySQL": {
                return MYSQL_UPDATE_NOT_RUN_QUERY;
            }
            case "MariaDB": {
                return MYSQL_UPDATE_NOT_RUN_QUERY;
            }
            case "MsSQLServer": {
                return "UPDATE snap_scheduler SET picked_by = null, picked = 0 WHERE picked = 1 AND end_run is null AND picked_by = ?;";
            }
            case "H2": {
                return "UPDATE snap_scheduler SET picked_by = null, picked = 0 WHERE picked = 1 AND end_run is null AND picked_by = ?;";
            }
        }
        return POSTGRE_UPDATE_NOT_RUN_QUERY;
    }

    private String selectTasksForUpdateQuery(String platform) {
        switch (platform) {
            case "MySQL": {
                return MYSQL_SELECT_QUERY;
            }
            case "MariaDB": {
                return MYSQL_SELECT_QUERY;
            }
            case "MsSQLServer": {
                return MSSQL_SELECT_QUERY;
            }
            case "H2": {
                return H2_SELECT_QUERY;
            }
        }
        return POSTGRE_SELECT_QUERY;
    }

    private String insertQuery(String platform) {
        switch (platform) {
            case "MySQL": {
                return MYSQL_INSERT_QUERY;
            }
            case "MariaDB": {
                return MYSQL_INSERT_QUERY;
            }
            case "MsSQLServer": {
                return MSSQL_INSERT_QUERY;
            }
            case "H2": {
                return H2_INSERT_QUERY;
            }
        }
        return POSTGRE_INSERT_QUERY;
    }

    private String updateQuery(String platform) {
        switch (platform) {
            case "MySQL": {
                return MYSQL_UPDATE_QUERY;
            }
            case "MariaDB": {
                return MYSQL_UPDATE_QUERY;
            }
            case "MsSQLServer": {
                return MSSQL_UPDATE_QUERY;
            }
            case "H2": {
                return "UPDATE snap_scheduler SET end_run = ? WHERE key = ?;";
            }
        }
        return "UPDATE snap_scheduler SET end_run = ? WHERE key = ?;";
    }
}

