/*
 * Decompiled with CFR 0.152.
 */
package io.opensw.scheduler.core.scheduler;

import io.opensw.scheduler.core.scheduler.SnapTaskHandler;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DbPullRunner
extends Thread {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DbPullRunner.class);
    private final SnapTaskHandler handler;
    private boolean running = true;
    private long interval;

    @Override
    public void run() {
        log.debug("# Start Thread SnapSchedulerRunner");
        if (this.interval >= 60000L) {
            try {
                while (this.running) {
                    log.debug("Handle tasks from database");
                    this.handler.handleDbTasks();
                    log.debug("End handling tasks from database");
                    Thread.sleep(this.interval);
                }
            }
            catch (Exception e) {
                log.error("Error on SnapSchedulerRunner polling thread running. Error: {}", (Object)e.getMessage());
            }
        } else {
            log.error("Scheduler database polling not started because db polling tim is less than 1 minute.");
        }
        log.debug("# END Thread SnapSchedulerRunner");
    }

    public synchronized void terminate() {
        this.running = false;
    }

    public synchronized void interval(long interval) {
        this.interval = interval;
    }

    @Generated
    public DbPullRunner(SnapTaskHandler handler) {
        this.handler = handler;
    }
}

