/*
 * Decompiled with CFR 0.152.
 */
package io.opensw.scheduler.core.utils;

import java.sql.Connection;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DbUtils.class);
    public static final String ERROR_CLOSE_STMT_MSG = "Error on trie to close statement, message: {}";
    public static final String DB_H2 = "H2";
    public static final String DB_POSTGRESQL = "PostgreSQL";
    public static final String DB_MYSQL = "MySQL";
    public static final String DB_MARIADB = "MariaDB";
    public static final String DB_MSSQL_SERVER = "MsSQLServer";

    private DbUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String databaseType(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            String productName = connection.getMetaData().getDatabaseProductName().replace(" ", "").toLowerCase().trim();
            if (productName == null || productName.isEmpty()) {
                String string = null;
                return string;
            }
            if (productName.contains(DB_POSTGRESQL.toLowerCase())) {
                String string = DB_POSTGRESQL;
                return string;
            }
            if (productName.contains(DB_MYSQL.toLowerCase())) {
                String string = DB_MYSQL;
                return string;
            }
            if (productName.contains(DB_MARIADB.toLowerCase())) {
                String string = DB_MARIADB;
                return string;
            }
            if (productName.contains("microsoft") || productName.contains("sqlserver")) {
                String string = DB_MSSQL_SERVER;
                return string;
            }
            if (!productName.equalsIgnoreCase(DB_H2)) return null;
            String string = DB_H2;
            return string;
        }
        catch (Exception e) {
            log.error("Error in identify DB type, erro: {}", (Object)e.getMessage());
        }
        return null;
    }
}

