/*
 * Decompiled with CFR 0.152.
 */
package io.opensw.scheduler;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="snap.scheduler")
public class SnapSchedulerProperties {
    private boolean enabled = true;
    @DurationUnit(value=ChronoUnit.MINUTES)
    private Duration dbPollingInterval;
    private DatabaseConfig datasource;

    public long dbPollingInterval() {
        if (this.dbPollingInterval == null || this.dbPollingInterval.isZero() || this.dbPollingInterval.isNegative()) {
            return 300000L;
        }
        return this.dbPollingInterval.toMillis();
    }

    @Generated
    public SnapSchedulerProperties() {
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public Duration getDbPollingInterval() {
        return this.dbPollingInterval;
    }

    @Generated
    public DatabaseConfig getDatasource() {
        return this.datasource;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setDbPollingInterval(Duration dbPollingInterval) {
        this.dbPollingInterval = dbPollingInterval;
    }

    @Generated
    public void setDatasource(DatabaseConfig datasource) {
        this.datasource = datasource;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnapSchedulerProperties)) {
            return false;
        }
        SnapSchedulerProperties other = (SnapSchedulerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Duration this$dbPollingInterval = this.getDbPollingInterval();
        Duration other$dbPollingInterval = other.getDbPollingInterval();
        if (this$dbPollingInterval == null ? other$dbPollingInterval != null : !((Object)this$dbPollingInterval).equals(other$dbPollingInterval)) {
            return false;
        }
        DatabaseConfig this$datasource = this.getDatasource();
        DatabaseConfig other$datasource = other.getDatasource();
        return !(this$datasource == null ? other$datasource != null : !((Object)this$datasource).equals(other$datasource));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnapSchedulerProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Duration $dbPollingInterval = this.getDbPollingInterval();
        result = result * 59 + ($dbPollingInterval == null ? 43 : ((Object)$dbPollingInterval).hashCode());
        DatabaseConfig $datasource = this.getDatasource();
        result = result * 59 + ($datasource == null ? 43 : ((Object)$datasource).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SnapSchedulerProperties(enabled=" + this.isEnabled() + ", dbPollingInterval=" + this.getDbPollingInterval() + ", datasource=" + this.getDatasource() + ")";
    }

    public static class DatabaseConfig {
        private String driverClassName;
        private String url;
        private String username;
        private String password;

        @Generated
        public DatabaseConfig() {
        }

        @Generated
        public String getDriverClassName() {
            return this.driverClassName;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public void setDriverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DatabaseConfig)) {
                return false;
            }
            DatabaseConfig other = (DatabaseConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$driverClassName = this.getDriverClassName();
            String other$driverClassName = other.getDriverClassName();
            if (this$driverClassName == null ? other$driverClassName != null : !this$driverClassName.equals(other$driverClassName)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DatabaseConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $driverClassName = this.getDriverClassName();
            result = result * 59 + ($driverClassName == null ? 43 : $driverClassName.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SnapSchedulerProperties.DatabaseConfig(driverClassName=" + this.getDriverClassName() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }
    }
}

