/*
 * Decompiled with CFR 0.152.
 */
package io.opensw.scheduler.core.config;

import io.opensw.scheduler.SnapSchedulerProperties;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync
@ComponentScan(value={"io.opensw.scheduler"})
public class SnapSchedulerConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnapSchedulerConfig.class);
    private final SnapSchedulerProperties properties;
    private final DataSourceProperties dataSourceProperties;

    @Bean(name={"snapDataSource"})
    public DataSource snapDataSource() {
        if (this.properties.getDatasource() != null) {
            log.info("Configure custom datasource.");
            DataSourceBuilder dataSourceBuilder = DataSourceBuilder.create();
            dataSourceBuilder.driverClassName(this.properties.getDatasource().getDriverClassName());
            dataSourceBuilder.url(this.properties.getDatasource().getUrl());
            dataSourceBuilder.username(this.properties.getDatasource().getUsername());
            dataSourceBuilder.password(this.properties.getDatasource().getPassword());
            return dataSourceBuilder.build();
        }
        log.info("Reuse existing datasource configuration.");
        return this.dataSourceProperties.initializeDataSourceBuilder().build();
    }

    @Generated
    public SnapSchedulerConfig(SnapSchedulerProperties properties, DataSourceProperties dataSourceProperties) {
        this.properties = properties;
        this.dataSourceProperties = dataSourceProperties;
    }
}

