/*
 * Decompiled with CFR 0.152.
 */
package io.opensw.scheduler.core.scheduler;

import io.opensw.scheduler.SnapSchedulerProperties;
import io.opensw.scheduler.core.domain.scheduler.SchedulerRepository;
import io.opensw.scheduler.core.exceptions.TaskDefinitionException;
import io.opensw.scheduler.core.exceptions.UnexpectedException;
import io.opensw.scheduler.core.scheduler.SnapTaskHandler;
import io.opensw.scheduler.core.scheduler.task.RecurringTask;
import io.opensw.scheduler.core.scheduler.task.Task;
import io.opensw.scheduler.core.scheduler.task.TaskDataExecutor;
import io.opensw.scheduler.core.scheduler.task.TaskExecutor;
import io.opensw.scheduler.core.scheduler.task.TaskType;
import io.opensw.scheduler.core.utils.ServerUtils;
import java.time.Duration;
import java.time.Instant;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SnapScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnapScheduler.class);
    private final SchedulerRepository schedulerRepository;
    private final SnapTaskHandler snapTaskHandler;
    private final SnapSchedulerProperties properties;

    public void schedule(Task task) throws TaskDefinitionException, UnexpectedException {
        log.debug("(SnapScheduler.schedule) Start schedule task with key {}.", (Object)task.getKey());
        this.validateTaskDefinition(task);
        long minutes = Duration.between(Instant.now(), task.getRunAt()).toMinutes();
        try {
            boolean picked = false;
            String server = null;
            if (minutes < 10L || minutes < this.properties.getDbPollingInterval().toMinutes() * 2L) {
                this.snapTaskHandler.handleTask(task);
                picked = true;
                server = ServerUtils.loadServerName();
            }
            this.schedulerRepository.insertTask(task, picked, server);
        }
        catch (Exception e) {
            log.error("Erro on schedule task {}. Error: {}", (Object)task.toString(), (Object)e.getMessage());
            throw new UnexpectedException(e.getMessage());
        }
    }

    private void validateTaskDefinition(Task task) throws TaskDefinitionException {
        if (!TaskDataExecutor.class.isAssignableFrom(task.getClazz()) && !TaskExecutor.class.isAssignableFrom(task.getClazz())) {
            throw TaskDefinitionException.create(String.format("Task class \"%s\" need to implement interface \"%s\"", task.getClazz().getCanonicalName(), TaskDataExecutor.class.getCanonicalName()));
        }
        if (task.getKey() == null || task.getKey().isEmpty()) {
            throw TaskDefinitionException.create("Task \"key\" field is required, please define it.");
        }
        if (task.getRunAt() == null) {
            throw TaskDefinitionException.create("Task \"runAt\" field is required, please define it.");
        }
        if (task.getClazz() == null) {
            throw TaskDefinitionException.create("Task \"clazz\" field is required, please define it.");
        }
        if (task.getType() == null) {
            throw TaskDefinitionException.create("Task \"type\" field is required, please define it.");
        }
        if (TaskType.RECURRING.equals((Object)task.getType()) && ((RecurringTask)task).getRecurrence() == null) {
            throw TaskDefinitionException.create("Task \"recurrence\" field is required for recurring tasks, please define it.");
        }
        if (task.getName() == null || task.getName().isEmpty()) {
            throw TaskDefinitionException.create("Task \"name\" field is required, please define it.");
        }
        if (task.getData() != null && task.getDataClazz() == null) {
            throw TaskDefinitionException.create("Task \"data\" was defined but \"dataClazz\" was null, please define \"dataClazz\".");
        }
    }

    @Generated
    public SnapScheduler(SchedulerRepository schedulerRepository, SnapTaskHandler snapTaskHandler, SnapSchedulerProperties properties) {
        this.schedulerRepository = schedulerRepository;
        this.snapTaskHandler = snapTaskHandler;
        this.properties = properties;
    }
}

