/*
 * Decompiled with CFR 0.152.
 */
package io.opensw.scheduler.core.scheduler;

import io.opensw.scheduler.core.events.obj.TaskRunEvent;
import io.opensw.scheduler.core.exceptions.BeanDefinitionException;
import io.opensw.scheduler.core.scheduler.task.Task;
import io.opensw.scheduler.core.scheduler.task.TaskDataExecutor;
import io.opensw.scheduler.core.scheduler.task.TaskExecutor;
import io.opensw.scheduler.core.utils.ServerUtils;
import java.time.Instant;
import java.util.TimerTask;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;

public class TimerTaskRunner
extends TimerTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimerTaskRunner.class);
    private final Task task;
    private final ApplicationContext context;
    private final ApplicationEventPublisher applicationEventPublisher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Instant start = Instant.now();
        Exception exception = null;
        try {
            TaskExecutor taskExecutor = this.loadInstance(this.task.getClazz());
            if (taskExecutor != null && TaskDataExecutor.class.isAssignableFrom(this.task.getClazz())) {
                ((TaskDataExecutor)taskExecutor).execute(this.task.getData());
            } else if (taskExecutor != null) {
                taskExecutor.execute();
            } else {
                exception = new BeanDefinitionException("(SnapTaskHandler.handleTask) TaskExecutor is null.");
                log.error("(SnapTaskHandler.handleTask) TaskExecutor is null.");
            }
        }
        catch (Exception e) {
            exception = e;
            log.error("(TimerTaskRunner.run) Error occur on run timer task with key {}. Error: {}", (Object)this.task.getKey(), (Object)e.getMessage());
        }
        finally {
            this.applicationEventPublisher.publishEvent((Object)TaskRunEvent.create(this.task, ServerUtils.loadServerName(), start, Instant.now(), exception));
        }
    }

    private TaskExecutor loadInstance(Class<?> clazz) {
        try {
            return (TaskExecutor)this.context.getBean(Class.forName(clazz.getName()));
        }
        catch (Exception e) {
            log.error("(SnapTaskHandler.loadInstance) Do not have instance in spring context of class {}", (Object)clazz.getName());
            return this.registerBean(clazz);
        }
    }

    private TaskExecutor registerBean(Class<?> clazz) {
        log.debug("(SnapTaskHandler.registerBean) Start register bean.");
        try {
            String beanName = StringUtils.uncapitalize((String)clazz.getSimpleName());
            ConfigurableApplicationContext cnt = (ConfigurableApplicationContext)this.context;
            DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)cnt.getBeanFactory();
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(clazz);
            beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
            return (TaskExecutor)this.context.getBean(Class.forName(clazz.getName()));
        }
        catch (Exception e) {
            log.error("(SnapTaskHandler.registerBean) Erro on register bean definition. Error: ", (Object)e.getMessage());
            return null;
        }
    }

    @Generated
    public TimerTaskRunner(Task task, ApplicationContext context, ApplicationEventPublisher applicationEventPublisher) {
        this.task = task;
        this.context = context;
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

