/*
 * Decompiled with CFR 0.152.
 */
package io.opensw.scheduler.core.scheduler;

import io.opensw.scheduler.SnapSchedulerProperties;
import io.opensw.scheduler.core.domain.scheduler.SchedulerRepository;
import io.opensw.scheduler.core.exceptions.DatabaseException;
import io.opensw.scheduler.core.scheduler.DbPullRunner;
import io.opensw.scheduler.core.utils.ServerUtils;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class SnapSchedulerRunner
implements CommandLineRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnapSchedulerRunner.class);
    private final DbPullRunner dbPullRunner;
    private final SchedulerRepository schedulerRepository;
    private final SnapSchedulerProperties properties;

    public void run(String ... arg0) throws Exception {
        log.debug("#=> Start SnapSchedulerRunner #");
        if (this.properties.isEnabled()) {
            this.dbPullRunner.interval(this.properties.dbPollingInterval());
            this.dbPullRunner.start();
        }
    }

    @PreDestroy
    public void onExit() throws DatabaseException {
        log.debug("#=> Call SnapSchedulerRunner exit runner #");
        this.dbPullRunner.terminate();
        this.schedulerRepository.updateNotRunnedTask(ServerUtils.loadServerName());
        log.debug("#=> SnapSchedulerRunner exit concluded #");
    }

    @Generated
    public SnapSchedulerRunner(DbPullRunner dbPullRunner, SchedulerRepository schedulerRepository, SnapSchedulerProperties properties) {
        this.dbPullRunner = dbPullRunner;
        this.schedulerRepository = schedulerRepository;
        this.properties = properties;
    }
}

