/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.aws.resource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BeanstalkResource {
    private static final Logger logger = Logger.getLogger(BeanstalkResource.class.getName());
    private static final String DEVELOPMENT_ID = "deployment_id";
    private static final String VERSION_LABEL = "version_label";
    private static final String ENVIRONMENT_NAME = "environment_name";
    private static final String BEANSTALK_CONF_PATH = "/var/elasticbeanstalk/xray/environment.conf";
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final Resource INSTANCE = BeanstalkResource.buildResource();

    public static Resource get() {
        return INSTANCE;
    }

    private static Resource buildResource() {
        return BeanstalkResource.buildResource(BEANSTALK_CONF_PATH);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Resource buildResource(String configPath) {
        File configFile = new File(configPath);
        if (!configFile.exists()) {
            return Resource.empty();
        }
        AttributesBuilder attrBuilders = Attributes.builder();
        try (JsonParser parser = JSON_FACTORY.createParser(configFile);){
            parser.nextToken();
            if (!parser.isExpectedStartObjectToken()) {
                logger.log(Level.WARNING, "Invalid Beanstalk config: ", configPath);
                Resource resource = Resource.create((Attributes)attrBuilders.build(), (String)"https://opentelemetry.io/schemas/1.13.0");
                return resource;
            }
            block18: while (parser.nextToken() != JsonToken.END_OBJECT) {
                parser.nextValue();
                String value = parser.getText();
                switch (parser.getCurrentName()) {
                    case "deployment_id": {
                        attrBuilders.put(ResourceAttributes.SERVICE_INSTANCE_ID, (Object)value);
                        continue block18;
                    }
                    case "version_label": {
                        attrBuilders.put(ResourceAttributes.SERVICE_VERSION, (Object)value);
                        continue block18;
                    }
                    case "environment_name": {
                        attrBuilders.put(ResourceAttributes.SERVICE_NAMESPACE, (Object)value);
                        continue block18;
                    }
                }
                parser.skipChildren();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not parse Beanstalk config.", e);
            return Resource.empty();
        }
        attrBuilders.put(ResourceAttributes.CLOUD_PROVIDER, (Object)"aws");
        attrBuilders.put(ResourceAttributes.CLOUD_PLATFORM, (Object)"aws_elastic_beanstalk");
        return Resource.create((Attributes)attrBuilders.build(), (String)"https://opentelemetry.io/schemas/1.13.0");
    }

    private BeanstalkResource() {
    }
}

