/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.awsxray.AwsXrayRemoteSampler;
import io.opentelemetry.contrib.awsxray.GetSamplingRulesResponse;
import io.opentelemetry.contrib.awsxray.GetSamplingTargetsRequest;
import io.opentelemetry.contrib.awsxray.GetSamplingTargetsResponse;
import io.opentelemetry.contrib.awsxray.SamplingRuleApplier;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

final class XrayRulesSampler
implements Sampler {
    private static final Logger logger = Logger.getLogger(XrayRulesSampler.class.getName());
    private final String clientId;
    private final Resource resource;
    private final Clock clock;
    private final Sampler fallbackSampler;
    private final SamplingRuleApplier[] ruleAppliers;

    XrayRulesSampler(String clientId, Resource resource, Clock clock, Sampler fallbackSampler, List<GetSamplingRulesResponse.SamplingRule> rules) {
        this(clientId, resource, clock, fallbackSampler, (SamplingRuleApplier[])rules.stream().sorted(Comparator.comparingInt(GetSamplingRulesResponse.SamplingRule::getPriority)).map(rule -> new SamplingRuleApplier(clientId, (GetSamplingRulesResponse.SamplingRule)rule, clock)).toArray(SamplingRuleApplier[]::new));
    }

    private XrayRulesSampler(String clientId, Resource resource, Clock clock, Sampler fallbackSampler, SamplingRuleApplier[] ruleAppliers) {
        this.clientId = clientId;
        this.resource = resource;
        this.clock = clock;
        this.fallbackSampler = fallbackSampler;
        this.ruleAppliers = ruleAppliers;
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        for (SamplingRuleApplier applier : this.ruleAppliers) {
            if (!applier.matches(attributes, this.resource)) continue;
            return applier.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
        }
        logger.log(Level.FINE, "No sampling rule matched the request. This is a bug in either the OpenTelemetry SDK or X-Ray.");
        return this.fallbackSampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
    }

    public String getDescription() {
        return "XrayRulesSampler{" + Arrays.toString(this.ruleAppliers) + "}";
    }

    List<GetSamplingTargetsRequest.SamplingStatisticsDocument> snapshot(Date now) {
        return Arrays.stream(this.ruleAppliers).map(rule -> rule.snapshot(now)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    long nextTargetFetchTimeNanos() {
        return Arrays.stream(this.ruleAppliers).mapToLong(SamplingRuleApplier::getNextSnapshotTimeNanos).min().orElseGet(() -> this.clock.nanoTime() + AwsXrayRemoteSampler.DEFAULT_TARGET_INTERVAL_NANOS);
    }

    XrayRulesSampler withTargets(Map<String, GetSamplingTargetsResponse.SamplingTargetDocument> ruleTargets, Set<String> requestedTargetRuleNames, Date now) {
        long defaultNextSnapshotTimeNanos = this.clock.nanoTime() + AwsXrayRemoteSampler.DEFAULT_TARGET_INTERVAL_NANOS;
        SamplingRuleApplier[] newAppliers = (SamplingRuleApplier[])Arrays.stream(this.ruleAppliers).map(rule -> {
            GetSamplingTargetsResponse.SamplingTargetDocument target = (GetSamplingTargetsResponse.SamplingTargetDocument)ruleTargets.get(rule.getRuleName());
            if (target != null) {
                return rule.withTarget(target, now);
            }
            if (requestedTargetRuleNames.contains(rule.getRuleName())) {
                return rule.withNextSnapshotTimeNanos(defaultNextSnapshotTimeNanos);
            }
            return rule;
        }).toArray(SamplingRuleApplier[]::new);
        return new XrayRulesSampler(this.clientId, this.resource, this.clock, this.fallbackSampler, newAppliers);
    }
}

