/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import io.opentelemetry.contrib.awsxray.AwsXrayRemoteSampler;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class AwsXrayRemoteSamplerBuilder {
    private static final String DEFAULT_ENDPOINT = "http://localhost:2000";
    private static final long DEFAULT_POLLING_INTERVAL_SECS = 300L;
    private final Resource resource;
    private Clock clock = Clock.getDefault();
    private String endpoint = "http://localhost:2000";
    private Sampler initialSampler = Sampler.parentBased((Sampler)Sampler.traceIdRatioBased((double)0.05));
    private long pollingIntervalNanos = TimeUnit.SECONDS.toNanos(300L);

    AwsXrayRemoteSamplerBuilder(Resource resource) {
        this.resource = resource;
    }

    public AwsXrayRemoteSamplerBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.endpoint = endpoint;
        return this;
    }

    public AwsXrayRemoteSamplerBuilder setPollingInterval(Duration delay) {
        Objects.requireNonNull(delay, "delay");
        return this.setPollingInterval(delay.toNanos(), TimeUnit.NANOSECONDS);
    }

    public AwsXrayRemoteSamplerBuilder setPollingInterval(long delay, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        if (delay < 0L) {
            throw new IllegalArgumentException("delay must be non-negative");
        }
        this.pollingIntervalNanos = unit.toNanos(delay);
        return this;
    }

    public AwsXrayRemoteSamplerBuilder setInitialSampler(Sampler initialSampler) {
        Objects.requireNonNull(initialSampler, "initialSampler");
        this.initialSampler = initialSampler;
        return this;
    }

    public AwsXrayRemoteSamplerBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public AwsXrayRemoteSampler build() {
        return new AwsXrayRemoteSampler(this.resource, this.clock, this.endpoint, this.initialSampler, this.pollingIntervalNanos);
    }
}

