/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.opentelemetry.contrib.awsxray.GetSamplingRulesRequest;
import io.opentelemetry.contrib.awsxray.GetSamplingRulesResponse;
import io.opentelemetry.contrib.awsxray.GetSamplingTargetsRequest;
import io.opentelemetry.contrib.awsxray.GetSamplingTargetsResponse;
import io.opentelemetry.contrib.awsxray.JdkHttpClient;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

final class XraySamplerClient {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).registerModule((Module)new SimpleModule().addDeserializer(Date.class, (JsonDeserializer)new FloatDateDeserializer())).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final Map<String, String> JSON_CONTENT_TYPE = Collections.singletonMap("Content-Type", "application/json");
    private final String getSamplingRulesEndpoint;
    private final String getSamplingTargetsEndpoint;
    private final JdkHttpClient httpClient;

    XraySamplerClient(String host) {
        this.getSamplingRulesEndpoint = host + "/GetSamplingRules";
        this.getSamplingTargetsEndpoint = host + "/SamplingTargets";
        this.httpClient = new JdkHttpClient();
    }

    GetSamplingRulesResponse getSamplingRules(GetSamplingRulesRequest request) {
        return this.executeJsonRequest(this.getSamplingRulesEndpoint, request, GetSamplingRulesResponse.class);
    }

    GetSamplingTargetsResponse getSamplingTargets(GetSamplingTargetsRequest request) {
        return this.executeJsonRequest(this.getSamplingTargetsEndpoint, request, GetSamplingTargetsResponse.class);
    }

    private <T> T executeJsonRequest(String endpoint, Object request, Class<T> responseType) {
        byte[] requestBody;
        try {
            requestBody = OBJECT_MAPPER.writeValueAsBytes(request);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException("Failed to serialize request.", (IOException)((Object)e));
        }
        String response = this.httpClient.fetchString("POST", endpoint, JSON_CONTENT_TYPE, null, requestBody);
        try {
            return (T)OBJECT_MAPPER.readValue(response, responseType);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException("Failed to deserialize response.", (IOException)((Object)e));
        }
    }

    private static class FloatDateDeserializer
    extends StdDeserializer<Date> {
        private static final long serialVersionUID = 4446058377205025341L;
        private static final int AWS_DATE_MILLI_SECOND_PRECISION = 3;

        private FloatDateDeserializer() {
            super(Date.class);
        }

        public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return FloatDateDeserializer.parseServiceSpecificDate(p.getText());
        }

        private static Date parseServiceSpecificDate(String dateString) {
            try {
                BigDecimal dateValue = new BigDecimal(dateString);
                return new Date(dateValue.scaleByPowerOfTen(3).longValue());
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Unable to parse date : " + dateString, nfe);
            }
        }
    }
}

