/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.opentelemetry.contrib.awsxray.GetSamplingRulesRequest;
import io.opentelemetry.contrib.awsxray.GetSamplingRulesResponse;
import io.opentelemetry.contrib.awsxray.GetSamplingTargetsRequest;
import io.opentelemetry.contrib.awsxray.GetSamplingTargetsResponse;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

final class XraySamplerClient {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).registerModule((Module)new SimpleModule().addDeserializer(Date.class, (JsonDeserializer)new FloatDateDeserializer())).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final MediaType JSON_CONTENT_TYPE = MediaType.get((String)"application/json");
    private static final Logger logger = Logger.getLogger(XraySamplerClient.class.getName());
    private final String getSamplingRulesEndpoint;
    private final String getSamplingTargetsEndpoint;
    private final Call.Factory httpClient;

    XraySamplerClient(String host) {
        this.getSamplingRulesEndpoint = host + "/GetSamplingRules";
        this.getSamplingTargetsEndpoint = host + "/SamplingTargets";
        this.httpClient = new OkHttpClient();
    }

    GetSamplingRulesResponse getSamplingRules(GetSamplingRulesRequest request) {
        return this.executeJsonRequest(this.getSamplingRulesEndpoint, request, GetSamplingRulesResponse.class);
    }

    GetSamplingTargetsResponse getSamplingTargets(GetSamplingTargetsRequest request) {
        return this.executeJsonRequest(this.getSamplingTargetsEndpoint, request, GetSamplingTargetsResponse.class);
    }

    private <T> T executeJsonRequest(String endpoint, Object request, Class<T> responseType) {
        String response;
        byte[] requestBody;
        try {
            requestBody = OBJECT_MAPPER.writeValueAsBytes(request);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException("Failed to serialize request.", (IOException)((Object)e));
        }
        Call call = this.httpClient.newCall(new Request.Builder().url(endpoint).post(RequestBody.create((MediaType)JSON_CONTENT_TYPE, (byte[])requestBody)).build());
        try (Response httpResponse = call.execute();){
            response = XraySamplerClient.readResponse(httpResponse, endpoint);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to execute sampling request.", e);
        }
        try {
            return (T)OBJECT_MAPPER.readValue(response, responseType);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException("Failed to deserialize response.", (IOException)((Object)e));
        }
    }

    private static String readResponse(Response response, String endpoint) throws IOException {
        if (!response.isSuccessful()) {
            logger.log(Level.FINE, "Error response from " + endpoint + " code (" + response.code() + ") text " + response.message());
            return "";
        }
        ResponseBody body = response.body();
        if (body != null) {
            return body.string();
        }
        return "";
    }

    String getSamplingRulesEndpoint() {
        return this.getSamplingRulesEndpoint;
    }

    private static class FloatDateDeserializer
    extends StdDeserializer<Date> {
        private static final long serialVersionUID = 4446058377205025341L;
        private static final int AWS_DATE_MILLI_SECOND_PRECISION = 3;

        private FloatDateDeserializer() {
            super(Date.class);
        }

        public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return FloatDateDeserializer.parseServiceSpecificDate(p.getText());
        }

        private static Date parseServiceSpecificDate(String dateString) {
            try {
                BigDecimal dateValue = new BigDecimal(dateString);
                return new Date(dateValue.scaleByPowerOfTen(3).longValue());
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Unable to parse date : " + dateString, nfe);
            }
        }
    }
}

