/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.autoconfigure;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkTracing;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;

public class TracingExecutionInterceptor
implements ExecutionInterceptor {
    private static final boolean CAPTURE_EXPERIMENTAL_SPAN_ATTRIBUTES = Config.get().getBoolean("otel.instrumentation.aws-sdk.experimental-span-attributes", false);
    private final ExecutionInterceptor delegate = AwsSdkTracing.builder((OpenTelemetry)GlobalOpenTelemetry.get()).setCaptureExperimentalSpanAttributes(CAPTURE_EXPERIMENTAL_SPAN_ATTRIBUTES).build().newExecutionInterceptor();

    public void beforeExecution(Context.BeforeExecution context, ExecutionAttributes executionAttributes) {
        this.delegate.beforeExecution(context, executionAttributes);
    }

    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        return this.delegate.modifyRequest(context, executionAttributes);
    }

    public void beforeMarshalling(Context.BeforeMarshalling context, ExecutionAttributes executionAttributes) {
        this.delegate.beforeMarshalling(context, executionAttributes);
    }

    public void afterMarshalling(Context.AfterMarshalling context, ExecutionAttributes executionAttributes) {
        this.delegate.afterMarshalling(context, executionAttributes);
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        return this.delegate.modifyHttpRequest(context, executionAttributes);
    }

    public Optional<RequestBody> modifyHttpContent(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        return this.delegate.modifyHttpContent(context, executionAttributes);
    }

    public Optional<AsyncRequestBody> modifyAsyncHttpContent(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        return this.delegate.modifyAsyncHttpContent(context, executionAttributes);
    }

    public void beforeTransmission(Context.BeforeTransmission context, ExecutionAttributes executionAttributes) {
        this.delegate.beforeTransmission(context, executionAttributes);
    }

    public void afterTransmission(Context.AfterTransmission context, ExecutionAttributes executionAttributes) {
        this.delegate.afterTransmission(context, executionAttributes);
    }

    public SdkHttpResponse modifyHttpResponse(Context.ModifyHttpResponse context, ExecutionAttributes executionAttributes) {
        return this.delegate.modifyHttpResponse(context, executionAttributes);
    }

    public Optional<Publisher<ByteBuffer>> modifyAsyncHttpResponseContent(Context.ModifyHttpResponse context, ExecutionAttributes executionAttributes) {
        return this.delegate.modifyAsyncHttpResponseContent(context, executionAttributes);
    }

    public Optional<InputStream> modifyHttpResponseContent(Context.ModifyHttpResponse context, ExecutionAttributes executionAttributes) {
        return this.delegate.modifyHttpResponseContent(context, executionAttributes);
    }

    public void beforeUnmarshalling(Context.BeforeUnmarshalling context, ExecutionAttributes executionAttributes) {
        this.delegate.beforeUnmarshalling(context, executionAttributes);
    }

    public void afterUnmarshalling(Context.AfterUnmarshalling context, ExecutionAttributes executionAttributes) {
        this.delegate.afterUnmarshalling(context, executionAttributes);
    }

    public SdkResponse modifyResponse(Context.ModifyResponse context, ExecutionAttributes executionAttributes) {
        return this.delegate.modifyResponse(context, executionAttributes);
    }

    public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        this.delegate.afterExecution(context, executionAttributes);
    }

    public Throwable modifyException(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        return this.delegate.modifyException(context, executionAttributes);
    }

    public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        this.delegate.onExecutionFailure(context, executionAttributes);
    }
}

