/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.elasticsearch.rest;

import io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.instrumentation.elasticsearch.rest.ElasticsearchRestClientTracer;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;

public class RestResponseListener
implements ResponseListener {
    private final ResponseListener listener;
    private final Context context;

    public RestResponseListener(ResponseListener listener, Context context) {
        this.listener = listener;
        this.context = context;
    }

    public void onSuccess(Response response) {
        if (response.getHost() != null) {
            ElasticsearchRestClientTracer.tracer().onResponse(this.context, response);
        }
        ElasticsearchRestClientTracer.tracer().end(this.context);
        this.listener.onSuccess(response);
    }

    public void onFailure(Exception e) {
        ElasticsearchRestClientTracer.tracer().endExceptionally(this.context, e);
        this.listener.onFailure(e);
    }
}

