/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.elasticsearch.transport;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbClientSpanNameExtractor;
import io.opentelemetry.javaagent.instrumentation.elasticsearch.transport.ElasticTransportRequest;
import io.opentelemetry.javaagent.instrumentation.elasticsearch.transport.ElasticsearchTransportAttributesGetter;
import org.elasticsearch.action.ActionResponse;

public final class ElasticsearchTransportInstrumenterFactory {
    private static final boolean CAPTURE_EXPERIMENTAL_SPAN_ATTRIBUTES = Config.get().getBoolean("otel.instrumentation.elasticsearch.experimental-span-attributes", false);

    public static Instrumenter<ElasticTransportRequest, ActionResponse> create(String instrumentationName, AttributesExtractor<ElasticTransportRequest, ActionResponse> experimentalAttributesExtractor, AttributesExtractor<ElasticTransportRequest, ActionResponse> netAttributesExtractor) {
        ElasticsearchTransportAttributesGetter dbClientAttributesGetter = new ElasticsearchTransportAttributesGetter();
        InstrumenterBuilder instrumenterBuilder = Instrumenter.builder((OpenTelemetry)GlobalOpenTelemetry.get(), (String)instrumentationName, (SpanNameExtractor)DbClientSpanNameExtractor.create((DbClientAttributesGetter)dbClientAttributesGetter)).addAttributesExtractor((AttributesExtractor)DbClientAttributesExtractor.create((DbClientAttributesGetter)dbClientAttributesGetter)).addAttributesExtractor(netAttributesExtractor);
        if (CAPTURE_EXPERIMENTAL_SPAN_ATTRIBUTES) {
            instrumenterBuilder.addAttributesExtractor(experimentalAttributesExtractor);
        }
        return instrumenterBuilder.newInstrumenter(SpanKindExtractor.alwaysClient());
    }

    private ElasticsearchTransportInstrumenterFactory() {
    }
}

