/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.elasticsearch.transport;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.javaagent.instrumentation.elasticsearch.transport.ElasticTransportRequest;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;

public class TransportActionListener<T extends ActionResponse>
implements ActionListener<T> {
    private final Instrumenter<ElasticTransportRequest, ActionResponse> instrumenter;
    private final ElasticTransportRequest actionRequest;
    private final ActionListener<T> listener;
    private final Context context;
    private final Context parentContext;

    public TransportActionListener(Instrumenter<ElasticTransportRequest, ActionResponse> instrumenter, ElasticTransportRequest actionRequest, ActionListener<T> listener, Context context, Context parentContext) {
        this.instrumenter = instrumenter;
        this.actionRequest = actionRequest;
        this.listener = listener;
        this.context = context;
        this.parentContext = parentContext;
    }

    public void onResponse(T response) {
        this.instrumenter.end(this.context, (Object)this.actionRequest, response, null);
        try (Scope ignored = this.parentContext.makeCurrent();){
            this.listener.onResponse(response);
        }
    }

    public void onFailure(Exception e) {
        this.instrumenter.end(this.context, (Object)this.actionRequest, null, (Throwable)e);
        try (Scope ignored = this.parentContext.makeCurrent();){
            this.listener.onFailure(e);
        }
    }
}

