/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.elasticsearch.transport;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.instrumentation.elasticsearch.transport.ElasticTransportRequest;
import javax.annotation.Nullable;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;

public class ElasticsearchTransportExperimentalAttributesExtractor
implements AttributesExtractor<ElasticTransportRequest, ActionResponse> {
    public void onStart(AttributesBuilder attributes, ElasticTransportRequest transportRequest) {
        CharSequence[] types;
        IndicesRequest req;
        CharSequence[] indices;
        Object request = transportRequest.getRequest();
        attributes.put("elasticsearch.action", transportRequest.getAction().getClass().getSimpleName());
        attributes.put("elasticsearch.request", request.getClass().getSimpleName());
        if (request instanceof IndicesRequest && (indices = (req = (IndicesRequest)request).indices()) != null && indices.length > 0) {
            attributes.put("elasticsearch.request.indices", String.join((CharSequence)",", indices));
        }
        if (request instanceof SearchRequest && (types = (req = (SearchRequest)request).types()) != null && types.length > 0) {
            attributes.put("elasticsearch.request.search.types", String.join((CharSequence)",", types));
        }
    }

    public void onEnd(AttributesBuilder attributes, ElasticTransportRequest request, ActionResponse response, @Nullable Throwable error) {
        GetResponse resp;
        if (response instanceof GetResponse) {
            resp = (GetResponse)response;
            attributes.put("elasticsearch.type", resp.getType());
            attributes.put("elasticsearch.id", resp.getId());
            attributes.put("elasticsearch.version", resp.getVersion());
        }
        if (response instanceof BroadcastResponse) {
            resp = (BroadcastResponse)response;
            attributes.put("elasticsearch.shard.broadcast.total", (long)resp.getTotalShards());
            attributes.put("elasticsearch.shard.broadcast.successful", (long)resp.getSuccessfulShards());
            attributes.put("elasticsearch.shard.broadcast.failed", (long)resp.getFailedShards());
        }
        if (response instanceof ReplicationResponse) {
            resp = (ReplicationResponse)response;
            attributes.put("elasticsearch.shard.replication.total", (long)resp.getShardInfo().getTotal());
            attributes.put("elasticsearch.shard.replication.successful", (long)resp.getShardInfo().getSuccessful());
            attributes.put("elasticsearch.shard.replication.failed", (long)resp.getShardInfo().getFailed());
        }
        if (response instanceof IndexResponse) {
            attributes.put("elasticsearch.response.status", (long)((IndexResponse)response).status().getStatus());
        }
        if (response instanceof BulkShardResponse) {
            resp = (BulkShardResponse)response;
            attributes.put("elasticsearch.shard.bulk.id", (long)resp.getShardId().getId());
            attributes.put("elasticsearch.shard.bulk.index", resp.getShardId().getIndexName());
        }
        if (response instanceof BaseNodesResponse) {
            resp = (BaseNodesResponse)response;
            if (resp.hasFailures()) {
                attributes.put("elasticsearch.node.failures", (long)resp.failures().size());
            }
            attributes.put("elasticsearch.node.cluster.name", resp.getClusterName().value());
        }
    }
}

