/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.hibernate;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.instrumentation.api.CallDepthThreadLocalMap;
import io.opentelemetry.javaagent.instrumentation.api.ContextStore;
import io.opentelemetry.javaagent.instrumentation.hibernate.HibernateTracer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SessionMethodUtils {
    public static final Set<String> SCOPE_ONLY_METHODS = new HashSet<String>(Arrays.asList("immediateLoad", "internalLoad"));

    public static <TARGET, ENTITY> Context startSpanFrom(ContextStore<TARGET, Context> contextStore, TARGET spanKey, String operationName, ENTITY entity) {
        Context sessionContext = (Context)contextStore.get(spanKey);
        if (sessionContext == null) {
            return null;
        }
        int depth = CallDepthThreadLocalMap.incrementCallDepth(SessionMethodUtils.class);
        if (depth > 0) {
            return null;
        }
        return HibernateTracer.tracer().startSpan(sessionContext, operationName, entity);
    }

    public static void end(@Nullable Context context, Throwable throwable, String operationName, Object entity) {
        String entityName;
        CallDepthThreadLocalMap.reset(SessionMethodUtils.class);
        if (context == null) {
            return;
        }
        if (operationName != null && entity != null && (entityName = HibernateTracer.tracer().entityName(entity)) != null) {
            Span.fromContext((Context)context).updateName(operationName + " " + entityName);
        }
        if (throwable != null) {
            HibernateTracer.tracer().endExceptionally(context, throwable);
        } else {
            HibernateTracer.tracer().end(context);
        }
    }

    public static <S, T> void attachSpanFromStore(ContextStore<S, Context> sourceContextStore, S source, ContextStore<T, Context> targetContextStore, T target) {
        Context sessionContext = (Context)sourceContextStore.get(source);
        if (sessionContext == null) {
            return;
        }
        targetContextStore.putIfAbsent(target, (Object)sessionContext);
    }
}

