/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.hibernate;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.javaagent.instrumentation.hibernate.HibernateExperimentalAttributesExtractor;
import io.opentelemetry.javaagent.instrumentation.hibernate.HibernateOperation;

public class HibernateSingletons {
    static final boolean CAPTURE_EXPERIMENTAL_SPAN_ATTRIBUTES = Config.get().getBoolean("otel.instrumentation.hibernate.experimental-span-attributes", false);
    private static final Instrumenter<HibernateOperation, Void> INSTANCE;

    public static Instrumenter<HibernateOperation, Void> instrumenter() {
        return INSTANCE;
    }

    static {
        InstrumenterBuilder instrumenterBuilder = Instrumenter.builder((OpenTelemetry)GlobalOpenTelemetry.get(), (String)"io.opentelemetry.hibernate-common", HibernateOperation::getName);
        if (CAPTURE_EXPERIMENTAL_SPAN_ATTRIBUTES) {
            instrumenterBuilder.addAttributesExtractor((AttributesExtractor)new HibernateExperimentalAttributesExtractor());
        }
        INSTANCE = instrumenterBuilder.newInstrumenter();
    }
}

